/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client;

import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.listing.ItemSet;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class GameUtil {
    public static final FlagHolder MOB_EFFECT_ACTIVE = FlagHolder.off();

    public static String getVersion() {
        return SharedConstants.getCurrentVersion().getName();
    }

    public static boolean isOnIntegratedSeverThread() {
        IntegratedServer integratedServer = Minecraft.getInstance().getSingleplayerServer();
        if (integratedServer == null) {
            return false;
        }
        return Thread.currentThread() == integratedServer.getRunningThread();
    }

    public static boolean isCreativeMode() {
        return Minecraft.getInstance().gameMode != null && Minecraft.getInstance().gameMode.hasInfiniteItems();
    }

    public static boolean isNotCreativeMode() {
        return !GameUtil.isCreativeMode();
    }

    public static boolean isSpectatorMode() {
        return Minecraft.getInstance().gameMode != null && Minecraft.getInstance().gameMode.isAlwaysFlying();
    }

    public static boolean isNotSpectatorMode() {
        return !GameUtil.isSpectatorMode();
    }

    public static boolean isSurvivalMode() {
        return GameUtil.isNotCreativeMode() && GameUtil.isNotSpectatorMode();
    }

    public static boolean isNotSurvivalMode() {
        return !GameUtil.isSurvivalMode();
    }

    @Nullable
    public static MinecraftServer getIntegratedServer() {
        return Minecraft.getInstance().getSingleplayerServer();
    }

    @Nullable
    public static ServerLevel getOverworldLevel() {
        if (Minecraft.getInstance().getSingleplayerServer() == null) {
            return null;
        }
        return Minecraft.getInstance().getSingleplayerServer().getLevel(Level.OVERWORLD);
    }

    public static boolean isInOverworld() {
        ClientLevel level = Minecraft.getInstance().level;
        return level != null && level.dimension().equals(Level.OVERWORLD);
    }

    public static boolean isInNether() {
        ClientLevel level = Minecraft.getInstance().level;
        return level != null && level.dimension().equals(Level.NETHER);
    }

    public static boolean isInEnd() {
        ClientLevel level = Minecraft.getInstance().level;
        return level != null && level.dimension().equals(Level.END);
    }

    public static boolean isModelFlat(ItemStack itemStack) {
        boolean usesBlockLight = Minecraft.getInstance().getItemRenderer().getModel(itemStack, null, null, 0).usesBlockLight();
        boolean isException = ((ItemSet)CandyTweak.OLD_2D_EXCEPTIONS.get()).containsItem(itemStack);
        return !usesBlockLight && !isException;
    }

    public static boolean isModelFlat(Item item) {
        return GameUtil.isModelFlat(item.getDefaultInstance());
    }

    public static int getRenderDistance() {
        return Minecraft.getInstance().options.getEffectiveRenderDistance();
    }

    public static int getOldRenderDistance() {
        int renderDistance = GameUtil.getRenderDistance();
        if (renderDistance >= 16) {
            return 0;
        }
        if (renderDistance >= 8) {
            return 1;
        }
        if (renderDistance >= 4) {
            return 2;
        }
        return 3;
    }
}

