/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client;

import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;

public abstract class CameraUtil {
    public static Camera get() {
        return Minecraft.getInstance().gameRenderer.getMainCamera();
    }

    public static boolean isFirstPerson() {
        return Minecraft.getInstance().options.getCameraType().isFirstPerson();
    }

    public static boolean isInFluid(Camera camera) {
        return camera.getFluidInCamera() != FogType.NONE;
    }

    public static boolean isBlind(Camera camera) {
        Entity entity = camera.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            return entity2.hasEffect(MobEffects.BLINDNESS);
        }
        return false;
    }

    public static boolean canSeeSky(Camera camera) {
        return camera.getEntity().level().canSeeSky(camera.getBlockPosition());
    }

    public static boolean isFoggy(Camera camera) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return false;
        }
        int x = Mth.floor((double)camera.getPosition().x());
        int y = Mth.floor((double)camera.getPosition().y());
        return level.effects().isFoggyAt(x, y) || minecraft.gui.getBossOverlay().shouldCreateWorldFog();
    }
}

