/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.listing;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import mod.adrenix.nostalgic.tweak.TweakValidator;
import mod.adrenix.nostalgic.tweak.factory.TweakListing;
import mod.adrenix.nostalgic.tweak.factory.TweakMap;
import mod.adrenix.nostalgic.tweak.gui.TweakSlider;
import mod.adrenix.nostalgic.tweak.listing.Listing;
import mod.adrenix.nostalgic.tweak.listing.ListingMap;

abstract class ListingValidator {
    ListingValidator() {
    }

    static <V, L extends ListingMap<V, L>> boolean map(ListingMap<V, L> listing, Map<String, V> map, TweakValidator validator, TweakListing<V, L> tweak, Consumer<Map.Entry<String, V>> onChange) {
        if (!Number.class.isAssignableFrom(listing.genericType())) {
            return true;
        }
        Optional<TweakMap<V, V>> tweakMap = TweakMap.cast(tweak);
        if (tweakMap.isEmpty()) {
            validator.exception(tweak, "Number maps must be assigned to tweaks that extend TweakMap.class");
            return false;
        }
        Optional<TweakSlider> mapSlider = tweakMap.get().getSlider();
        if (mapSlider.isEmpty()) {
            validator.exception(tweak, "Number maps must have slider data defined in the tweak builder");
            return false;
        }
        TweakSlider slider = mapSlider.get();
        double min = slider.getMin().doubleValue();
        double max = slider.getMax().doubleValue();
        boolean hasNotChanged = true;
        for (Map.Entry<String, V> entry : map.entrySet()) {
            Number number;
            double value;
            V v = entry.getValue();
            if (!(v instanceof Number) || !((value = (number = (Number)v).doubleValue()) < min) && !(value > max)) continue;
            hasNotChanged = false;
            String message = "%s key [%s] has an invalid number [%s] which was changed to: %s";
            validator.warn(message, tweak, entry.getKey(), value, listing.getDefaultValue());
            onChange.accept(entry);
        }
        if (validator.ok()) {
            validator.debug("%s was successfully validated with %s entries", tweak, map.size());
        }
        return hasNotChanged;
    }

    static <V, L extends Listing<V, L>> boolean set(Listing<V, L> listing, Set<V> set, TweakValidator validator, TweakListing<V, L> tweak) {
        if (Number.class.isAssignableFrom(listing.genericType())) {
            validator.exception(tweak, "Number sets are currently not supported");
        }
        if (validator.erred()) {
            return false;
        }
        if (validator.ok()) {
            validator.debug("%s was successfully validated with %s entries", tweak, set.size());
        }
        return true;
    }
}

