/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.listing;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.Set;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakListing;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;
import mod.adrenix.nostalgic.tweak.listing.ListingMap;
import mod.adrenix.nostalgic.tweak.listing.ListingSet;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public class ListingPackager<T extends TweakListing<?, ?>> {
    @Nullable
    private final T tweak;
    private final boolean disabled;

    public ListingPackager(@Nullable T tweak, boolean disabled) {
        this.tweak = tweak;
        this.disabled = disabled;
    }

    public ListingPackager(String poolId, Class<? super T> classType, boolean disabled) {
        Tweak found = TweakPool.find(poolId).orElse(null);
        if (found != null) {
            if (classType.isAssignableFrom(found.getClass())) {
                this.tweak = (TweakListing)found;
                this.disabled = disabled;
            } else {
                NostalgicTweaks.LOGGER.warn("Unable to cast packager [tweak={jsonId:%s, classType:%s}]", poolId, classType);
                this.tweak = null;
                this.disabled = true;
            }
        } else {
            NostalgicTweaks.LOGGER.warn("Unable to find listing using [tweak={jsonId:%s}]", poolId);
            this.tweak = null;
            this.disabled = true;
        }
    }

    @Nullable
    public T getTweak() {
        return this.tweak;
    }

    @Nullable
    public ListingSet<?, ?> getListingSet(Set<?> set) {
        if (this.tweak == null) {
            return null;
        }
        Object l = ((TweakListing)this.tweak).getDefault().create();
        if (l instanceof ListingSet) {
            ListingSet listing = (ListingSet)l;
            listing.clear();
            listing.acceptSafely(set);
            listing.setDisabled(this.disabled);
            return listing;
        }
        return null;
    }

    @Nullable
    public ListingMap<?, ?> getListingMap(Map<String, ?> map) {
        if (this.tweak == null) {
            return null;
        }
        Object l = ((TweakListing)this.tweak).getDefault().create();
        if (l instanceof ListingMap) {
            ListingMap listing = (ListingMap)l;
            listing.clear();
            listing.acceptSafely(map);
            listing.setDisabled(this.disabled);
            return listing;
        }
        return null;
    }

    public Object readValue(FriendlyByteBuf buffer) {
        if (this.tweak == null) {
            return new Gson().fromJson(buffer.readUtf(), Object.class);
        }
        try {
            return new Gson().fromJson(buffer.readUtf(), ((TweakListing)this.tweak).getDefault().genericType());
        }
        catch (JsonSyntaxException exception) {
            String jsonId = ((Tweak)this.tweak).getJsonPathId();
            String genericType = ((TweakListing)this.tweak).getDefault().genericType().toString();
            NostalgicTweaks.LOGGER.error("Could not parse [tweak={jsonId:%s}] using (%s)", jsonId, genericType);
            return new Gson().fromJson(buffer.readUtf(), Object.class);
        }
    }

    public void writeValue(FriendlyByteBuf buffer, Object object) {
        buffer.writeUtf(object.toString());
    }
}

