/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.listing;

import java.util.Arrays;
import java.util.LinkedHashSet;
import mod.adrenix.nostalgic.tweak.TweakValidator;
import mod.adrenix.nostalgic.tweak.factory.TweakListing;
import mod.adrenix.nostalgic.tweak.listing.DeletableSet;
import mod.adrenix.nostalgic.tweak.listing.ItemListing;
import mod.adrenix.nostalgic.tweak.listing.ItemRule;
import mod.adrenix.nostalgic.tweak.listing.ListingValidator;

public class ItemSet
extends ItemListing<String, ItemSet>
implements DeletableSet<String, ItemSet> {
    private final transient LinkedHashSet<String> deleted = new LinkedHashSet();
    private final LinkedHashSet<String> items = new LinkedHashSet<String>(){

        @Override
        public boolean remove(Object o) {
            super.remove(o.toString() + "*");
            return super.remove(o);
        }
    };

    public ItemSet(ItemRule ... rules) {
        this.rules.addAll(Arrays.asList(rules));
    }

    public ItemSet() {
    }

    public ItemSet startWith(LinkedHashSet<String> set) {
        this.items.addAll(set);
        return this;
    }

    @Override
    public LinkedHashSet<String> getSet() {
        return this.items;
    }

    public LinkedHashSet<String> getResourceKeys() {
        return this.items;
    }

    @Override
    public LinkedHashSet<String> getDeleted() {
        return this.deleted;
    }

    @Override
    public ItemSet create() {
        return new ItemSet(this.rules.toArray(new ItemRule[0])).startWith(this.items);
    }

    @Override
    public void addWildcard(String resourceKey) {
        this.items.add(this.getWildcard(resourceKey));
    }

    @Override
    public void removeWildcard(String resourceKey) {
        this.items.remove(this.getWildcard(resourceKey));
    }

    @Override
    public void copy(ItemSet list) {
        this.addAll(list.items);
        this.addAll(list.deleted);
        this.disabled = list.disabled;
    }

    @Override
    public void clear() {
        this.items.clear();
        this.deleted.clear();
    }

    @Override
    public boolean matches(ItemSet listing) {
        return this.items.equals(listing.items) && this.disabled == listing.disabled;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.items.contains(object);
    }

    @Override
    public boolean validate(TweakValidator validator, TweakListing<String, ItemSet> tweak) {
        return ListingValidator.set(this, this.items, validator, tweak);
    }

    @Override
    public Class<String> genericType() {
        return String.class;
    }

    @Override
    public String debugString() {
        return String.format("ItemSet{size:%s, disabled:%s}", this.items.size(), this.disabled);
    }

    public String toString() {
        return this.debugString();
    }
}

