/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.listing;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import mod.adrenix.nostalgic.tweak.TweakValidator;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakListing;
import mod.adrenix.nostalgic.tweak.listing.DeletableMap;
import mod.adrenix.nostalgic.tweak.listing.ItemListing;
import mod.adrenix.nostalgic.tweak.listing.ItemRule;
import mod.adrenix.nostalgic.tweak.listing.ListingValidator;
import mod.adrenix.nostalgic.util.common.world.ItemUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class ItemMap<V>
extends ItemListing<V, ItemMap<V>>
implements DeletableMap<V, ItemMap<V>> {
    private final LinkedHashMap<String, V> items = new LinkedHashMap<String, V>(){

        @Override
        public V remove(Object key) {
            super.remove(key.toString() + "*");
            return super.remove(key);
        }

        @Override
        public boolean remove(Object key, Object value) {
            super.remove(key.toString() + "*", value);
            return super.remove(key, value);
        }
    };
    private final transient LinkedHashMap<String, V> deleted = new LinkedHashMap();
    private final transient V defaultValue;

    public ItemMap(V defaultValue) {
        this.defaultValue = defaultValue;
    }

    private ItemMap() {
        this.defaultValue = null;
    }

    public ItemMap<V> startWith(LinkedHashMap<String, V> map) {
        this.items.putAll(map);
        return this;
    }

    public ItemMap<V> rules(ItemRule ... rules) {
        this.rules.addAll(Arrays.asList(rules));
        return this;
    }

    public V valueFrom(Item item) {
        String childKey = ItemUtil.getResourceKey(item);
        if (this.items.containsKey(childKey)) {
            return this.items.get(childKey);
        }
        Optional<Item> parent = this.getParentItemFromWildcard(item);
        if (parent.isEmpty()) {
            return this.defaultValue;
        }
        return this.items.getOrDefault(ItemUtil.getResourceKey(parent.get()), this.defaultValue);
    }

    public V valueFrom(ItemStack itemStack) {
        return this.valueFrom(itemStack.getItem());
    }

    public V valueFrom(Block block) {
        return this.valueFrom(block.asItem());
    }

    @Override
    public LinkedHashMap<String, V> getMap() {
        return this.items;
    }

    @Override
    public LinkedHashMap<String, V> getDeleted() {
        return this.deleted;
    }

    @Override
    public Set<String> getResourceKeys() {
        return this.items.keySet();
    }

    @Override
    public V getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public ItemMap<V> create() {
        return new ItemMap<V>(this.defaultValue).startWith(this.items).rules(this.rules.toArray(new ItemRule[0]));
    }

    @Override
    public void addWildcard(String resourceKey) {
        this.items.put(this.getWildcard(resourceKey), this.items.getOrDefault(resourceKey, this.defaultValue));
    }

    @Override
    public void removeWildcard(String resourceKey) {
        this.items.remove(this.getWildcard(resourceKey));
    }

    @Override
    public void copy(ItemMap<V> list) {
        this.putAll(list.items);
        this.putAll(list.deleted);
        this.disabled = list.disabled;
    }

    @Override
    public void clear() {
        this.items.clear();
        this.deleted.clear();
    }

    @Override
    public boolean matches(ItemMap<V> listing) {
        return this.items.equals(listing.items) && this.disabled == listing.disabled;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.items.containsKey((String)object);
    }

    @Override
    public boolean validate(TweakValidator validator, TweakListing<V, ItemMap<V>> tweak) {
        return ListingValidator.map(this, this.items, validator, tweak, entry -> {
            ((ItemMap)tweak.fromDisk()).applySafely((String)entry.getKey(), this.defaultValue, this::put);
            ((ItemMap)tweak.fromCache()).applySafely((String)entry.getKey(), this.defaultValue, this::put);
        });
    }

    public static Optional<TweakListing<Object, ItemMap<Object>>> cast(Tweak<?> tweak) {
        if (tweak instanceof TweakListing && tweak.fromDisk() instanceof ItemMap) {
            return Optional.of((TweakListing)tweak);
        }
        return Optional.empty();
    }

    @Override
    public Class<V> genericType() {
        return this.defaultValue.getClass();
    }

    @Override
    public String debugString() {
        String type = this.genericType().getSimpleName();
        int mapSize = this.items.size();
        boolean disabled = this.disabled;
        return String.format("ItemMap<%s>{mapSize:%s, disabled:%s}", type, mapSize, disabled);
    }

    public String toString() {
        return this.debugString();
    }
}

