/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.listing;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import mod.adrenix.nostalgic.tweak.listing.ItemRule;
import mod.adrenix.nostalgic.tweak.listing.Listing;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.world.ItemUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ItemListing<V, L extends Listing<V, L>>
implements Listing<V, L> {
    public static final String WILDCARD = "*";
    protected final transient HashSet<ItemRule> rules = new HashSet();
    protected final transient Object2BooleanMap<Item> itemCache = Object2BooleanMaps.synchronize((Object2BooleanMap)new Object2BooleanOpenHashMap());
    protected final transient Object2BooleanMap<Block> blockCache = Object2BooleanMaps.synchronize((Object2BooleanMap)new Object2BooleanOpenHashMap());
    protected boolean disabled = false;

    public static Set<String> getWildcardKeys(Block block) {
        String resourceKey = ItemUtil.getResourceKey(block);
        return Set.of(resourceKey, resourceKey + WILDCARD);
    }

    @Override
    public void setDisabled(boolean state) {
        this.disabled = state;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void resetTransientCache() {
        this.itemCache.clear();
        this.blockCache.clear();
        Listing.super.resetTransientCache();
    }

    public HashSet<ItemRule> rules() {
        if (this.rules.isEmpty()) {
            this.rules.add(ItemRule.NONE);
        }
        return this.rules;
    }

    public boolean areRulesEmpty() {
        return this.rules().stream().anyMatch(rule -> rule.equals((Object)ItemRule.NONE));
    }

    public boolean hasItemRule() {
        return !this.areRulesEmpty();
    }

    public abstract Set<String> getResourceKeys();

    public abstract void addWildcard(String var1);

    public abstract void removeWildcard(String var1);

    protected String getWildcard(String resourceKey) {
        return resourceKey + WILDCARD;
    }

    public boolean isWildcard(String resourceKey) {
        return resourceKey.endsWith(WILDCARD);
    }

    public boolean containsWildcard(String resourceKey) {
        return this.getResourceKeys().contains(resourceKey + WILDCARD);
    }

    public Optional<Block> getParentBlockFromWildcard(Block block) {
        for (String key : this.getResourceKeys()) {
            Block wildcard;
            if (!this.isWildcard(key) || !ClassUtil.isInstanceOf(block, (wildcard = ItemUtil.getBlock(key.replace(WILDCARD, ""))).getClass())) continue;
            return Optional.of(wildcard);
        }
        return Optional.empty();
    }

    public Optional<Item> getParentItemFromWildcard(Item item) {
        for (String key : this.getResourceKeys()) {
            Item wildcard;
            if (!this.isWildcard(key) || !ClassUtil.isInstanceOf(item, (wildcard = ItemUtil.getItem(key.replace(WILDCARD, ""))).getClass())) continue;
            return Optional.of(wildcard);
        }
        return Optional.empty();
    }

    public boolean isBlockWildcard(Block block) {
        return this.getParentBlockFromWildcard(block).isPresent();
    }

    public boolean isItemWildcard(Item item) {
        return this.getParentItemFromWildcard(item).isPresent();
    }

    public boolean containsBlock(Block block) {
        return this.blockCache.computeIfAbsent((Object)block, this::lookupBlock);
    }

    public boolean containsBlock(BlockState blockState) {
        return this.containsBlock(blockState.getBlock());
    }

    private boolean lookupBlock(Block block) {
        if (this.containsKey(ItemUtil.getResourceKey(block))) {
            return true;
        }
        return this.isBlockWildcard(block);
    }

    public boolean containsItem(Item item) {
        return this.itemCache.computeIfAbsent((Object)item, this::lookupItem);
    }

    public boolean containsItem(ItemStack itemStack) {
        return this.containsItem(itemStack.getItem());
    }

    private boolean lookupItem(Item item) {
        if (this.containsKey(ItemUtil.getResourceKey(item))) {
            return true;
        }
        return this.isItemWildcard(item);
    }
}

