/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.gui;

import java.util.function.Function;
import mod.adrenix.nostalgic.tweak.gui.SliderType;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.network.chat.MutableComponent;

public class TweakSlider {
    private final Builder builder;

    private TweakSlider(Builder builder) {
        this.builder = builder;
    }

    private static String defaultFormatting(Number input) {
        return input.toString();
    }

    public SliderType getType() {
        return this.builder.type;
    }

    public MutableComponent getTranslation() {
        return this.builder.langKey.get(new Object[0]);
    }

    public String getSuffix() {
        return this.builder.suffix;
    }

    public Number getMin() {
        return this.builder.min;
    }

    public Number getMax() {
        return this.builder.max;
    }

    public Number getInterval() {
        return this.builder.interval;
    }

    public int getRoundTo() {
        return this.builder.roundTo;
    }

    public Function<Number, String> getFormatter() {
        return this.builder.formatter;
    }

    public static Builder create(Number min, Number max, Number interval) {
        return new Builder(min, max, interval);
    }

    public static Builder create(int min, int max) {
        return TweakSlider.create(min, max, 1);
    }

    public static Builder create(long min, long max) {
        return TweakSlider.create(min, max, 1L);
    }

    public static Builder create(Number defaultNumber) {
        return TweakSlider.create(defaultNumber, defaultNumber, 1L);
    }

    public static class Builder
    implements Factory<Builder> {
        private Number min;
        private Number max;
        private Number interval;
        private int roundTo;
        private Function<Number, String> formatter = TweakSlider::defaultFormatting;
        private SliderType type = SliderType.GENERIC;
        private Translation langKey = new Translation("");
        private String suffix = "";

        private Builder(Number min, Number max, Number interval) {
            this.min = min;
            this.max = max;
            this.interval = interval;
            this.roundTo = 2;
        }

        @Override
        public Builder range(Number min, Number max) {
            this.min = min;
            this.max = max;
            return this;
        }

        @Override
        public Builder interval(Number interval) {
            this.interval = interval;
            return this;
        }

        @Override
        public Builder roundTo(int place) {
            this.roundTo = place;
            return this;
        }

        @Override
        public Builder formatter(Function<Number, String> formatter) {
            this.formatter = formatter;
            return this;
        }

        @Override
        public Builder langKey(Translation langKey) {
            this.langKey = langKey;
            return this;
        }

        @Override
        public Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        @Override
        public Builder type(SliderType type) {
            this.type = type;
            return this;
        }

        public TweakSlider build() {
            if (this.min == null) {
                throw new NullPointerException("Minimum slider bound cannot be null");
            }
            if (this.max == null) {
                throw new NullPointerException("Maximum slider bound cannot be null");
            }
            if (this.interval == null) {
                throw new NullPointerException("Slider interval cannot be null");
            }
            return new TweakSlider(this);
        }
    }

    public static interface Factory<Builder> {
        public Builder range(Number var1, Number var2);

        public Builder interval(Number var1);

        public Builder roundTo(int var1);

        public Builder formatter(Function<Number, String> var1);

        public Builder langKey(Translation var1);

        public Builder suffix(String var1);

        public Builder type(SliderType var1);

        default public Builder slider(Translation title, Number min, Number max) {
            this.langKey(title);
            return this.range(min, max);
        }

        default public Builder slider(Translation title, Number min, Number max, String suffix) {
            this.range(min, max);
            this.langKey(title);
            return this.suffix(suffix);
        }

        default public Builder slider(Number min, Number max, Number interval, SliderType sliderType) {
            this.range(min, max, interval);
            return this.type(sliderType);
        }

        default public Builder slider(Number min, Number max, SliderType sliderType) {
            this.range(min, max);
            return this.type(sliderType);
        }

        default public Builder range(Number min, Number max, Number interval) {
            this.range(min, max);
            return this.interval(interval);
        }

        default public Builder apply(Function<Factory<Builder>, Builder> function) {
            return function.apply(this);
        }
    }
}

