/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.factory;

import mod.adrenix.nostalgic.network.packet.tweak.ClientboundTweakText;
import mod.adrenix.nostalgic.network.packet.tweak.ServerboundTweakText;
import mod.adrenix.nostalgic.network.packet.tweak.TweakPacket;
import mod.adrenix.nostalgic.tweak.TweakEnv;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.tweak.factory.TweakValue;
import org.jetbrains.annotations.Nullable;

public class TweakText
extends TweakValue<String> {
    public static Builder client(String defaultText, Container container) {
        return new Builder(defaultText, TweakEnv.CLIENT, container);
    }

    public static Builder server(String defaultText, Container container) {
        return new Builder(defaultText, TweakEnv.SERVER, container);
    }

    public static Builder dynamic(String defaultText, Container container) {
        return new Builder(defaultText, TweakEnv.DYNAMIC, container);
    }

    TweakText(Builder builder) {
        super(builder);
    }

    @Override
    protected String result() {
        return ((String)super.result()).replaceAll("%([a-fA-F\\d])", "\u00a7$1");
    }

    @Override
    @Nullable
    public TweakPacket getClientboundPacket() {
        return new ClientboundTweakText(this);
    }

    @Override
    @Nullable
    public TweakPacket getServerboundPacket() {
        return new ServerboundTweakText(this);
    }

    public String parse(String value) {
        return ((String)this.get()).replaceAll("%v", value);
    }

    public static class Builder
    extends TweakValue.Builder<String, Builder> {
        Builder(String defaultValue, TweakEnv env, Container container) {
            super(defaultValue, env, container);
        }

        @Override
        Builder self() {
            return this;
        }

        public TweakText build() {
            return new TweakText(this);
        }
    }
}

