/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.factory;

import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.network.packet.tweak.ClientboundStatusUpdate;
import mod.adrenix.nostalgic.tweak.TweakEnv;
import mod.adrenix.nostalgic.tweak.TweakStatus;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.util.client.network.NetUtil;
import mod.adrenix.nostalgic.util.common.network.PacketUtil;

abstract class TweakPipeline {
    TweakPipeline() {
    }

    private static boolean isTweakOn(Tweak<?> tweak) {
        if (tweak.isIgnored()) {
            return true;
        }
        if (tweak.getEnvStatus() != TweakStatus.LOADED) {
            tweak.setEnvStatus(TweakStatus.LOADED);
            if (NostalgicTweaks.isServer() && NostalgicTweaks.getServer() != null) {
                PacketUtil.sendToAll(new ClientboundStatusUpdate(tweak));
            } else if (NostalgicTweaks.isClient() && NetUtil.getIntegratedServer() != null) {
                PacketUtil.sendToAll(NetUtil.getIntegratedPlayers(), new ClientboundStatusUpdate(tweak));
            }
        }
        if (tweak.isModConflict()) {
            return false;
        }
        if (NostalgicTweaks.isServer()) {
            return true;
        }
        if (NetUtil.isLocalHost()) {
            return true;
        }
        boolean isModEnabled = (Boolean)ModTweak.ENABLED.fromDisk();
        if (isModEnabled && tweak.isNetworkCheckIgnored()) {
            return true;
        }
        if (!NostalgicTweaks.isNetworkVerified() && tweak.getEnv() == TweakEnv.SERVER) {
            return false;
        }
        return isModEnabled;
    }

    private static <T> T getValue(Tweak<T> tweak) {
        if (tweak.isIgnored()) {
            return tweak.fromDisk();
        }
        if (NostalgicTweaks.isServer() || NetUtil.isSingleplayer()) {
            return tweak.fromDisk();
        }
        if (tweak.getEnv() != TweakEnv.CLIENT && NetUtil.isMultiplayer()) {
            return NostalgicTweaks.isNetworkVerified() ? tweak.fromServer() : tweak.fromDisk();
        }
        return tweak.fromDisk();
    }

    public static <T> T get(Tweak<T> tweak) {
        return TweakPipeline.isTweakOn(tweak) ? TweakPipeline.getValue(tweak) : tweak.getDisabled();
    }
}

