/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.factory;

import java.util.function.Function;
import mod.adrenix.nostalgic.network.packet.tweak.ClientboundTweakNumber;
import mod.adrenix.nostalgic.network.packet.tweak.ServerboundTweakNumber;
import mod.adrenix.nostalgic.network.packet.tweak.TweakPacket;
import mod.adrenix.nostalgic.tweak.TweakEnv;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.tweak.factory.TweakValue;
import mod.adrenix.nostalgic.tweak.gui.SliderType;
import mod.adrenix.nostalgic.tweak.gui.TweakSlider;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import org.jetbrains.annotations.Nullable;

public class TweakNumber<T extends Number>
extends TweakValue<T> {
    private final Builder<T> builder;

    public static <N extends Number> Builder<N> client(N defaultNumber, Container container) {
        return new Builder<N>(defaultNumber, TweakEnv.CLIENT, container);
    }

    public static <N extends Number> Builder<N> server(N defaultNumber, Container container) {
        return new Builder<N>(defaultNumber, TweakEnv.SERVER, container);
    }

    public static <N extends Number> Builder<N> dynamic(N defaultNumber, Container container) {
        return new Builder<N>(defaultNumber, TweakEnv.DYNAMIC, container);
    }

    TweakNumber(Builder<T> builder) {
        super(builder);
        this.builder = builder;
    }

    @Override
    public void setCacheValue(Number number) {
        if (this.isLocalMode()) {
            this.setLocal(number);
        } else {
            this.setNetwork(number);
        }
    }

    @Override
    public void setLocal(Number value) {
        this.getCacheHolder().setLocal(value);
    }

    @Override
    public void setNetwork(Number value) {
        this.getCacheHolder().setNetwork(value);
    }

    @Override
    @Nullable
    public TweakPacket getClientboundPacket() {
        return new ClientboundTweakNumber(this);
    }

    @Override
    @Nullable
    public TweakPacket getServerboundPacket() {
        return new ServerboundTweakNumber(this);
    }

    public TweakSlider getSlider() {
        return this.builder.slider.build();
    }

    public static class Builder<U extends Number>
    extends TweakValue.Builder<U, Builder<U>>
    implements TweakSlider.Factory<Builder<U>> {
        final TweakSlider.Builder slider;

        Builder(U defaultValue, TweakEnv env, Container container) {
            super(defaultValue, env, container);
            this.slider = TweakSlider.create(defaultValue);
        }

        @Override
        Builder<U> self() {
            return this;
        }

        @Override
        public Builder<U> range(Number min, Number max) {
            this.slider.range(min, max);
            return this;
        }

        @Override
        public Builder<U> interval(Number interval) {
            this.slider.interval(interval);
            return this;
        }

        @Override
        public Builder<U> roundTo(int place) {
            this.slider.roundTo(place);
            return this;
        }

        @Override
        public Builder<U> formatter(Function<Number, String> formatter) {
            this.slider.formatter((Function)formatter);
            return this;
        }

        @Override
        public Builder<U> langKey(Translation langKey) {
            this.slider.langKey(langKey);
            return this;
        }

        @Override
        public Builder<U> suffix(String suffix) {
            this.slider.suffix(suffix);
            return this;
        }

        @Override
        public Builder<U> type(SliderType type) {
            this.slider.type(type);
            return this;
        }

        public TweakNumber<U> build() {
            return new TweakNumber(this);
        }
    }
}

