/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.factory;

import mod.adrenix.nostalgic.network.packet.tweak.ClientboundTweakItemMap;
import mod.adrenix.nostalgic.network.packet.tweak.ServerboundTweakItemMap;
import mod.adrenix.nostalgic.network.packet.tweak.TweakPacket;
import mod.adrenix.nostalgic.tweak.TweakEnv;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.tweak.factory.TweakMap;
import mod.adrenix.nostalgic.tweak.listing.ItemMap;
import org.jetbrains.annotations.Nullable;

public class TweakItemMap<T>
extends TweakMap<T, ItemMap<T>> {
    public static <V> Builder<V> client(ItemMap<V> defaultMap, Container container) {
        return new Builder<V>(defaultMap, TweakEnv.CLIENT, container);
    }

    public static <V> Builder<V> server(ItemMap<V> defaultMap, Container container) {
        return new Builder<V>(defaultMap, TweakEnv.SERVER, container);
    }

    public static <V> Builder<V> dynamic(ItemMap<V> defaultMap, Container container) {
        return new Builder<V>(defaultMap, TweakEnv.DYNAMIC, container);
    }

    TweakItemMap(TweakMap.Builder<?, T, ItemMap<T>> builder) {
        super(builder);
    }

    @Override
    @Nullable
    public TweakPacket getClientboundPacket() {
        return new ClientboundTweakItemMap(this);
    }

    @Override
    @Nullable
    public TweakPacket getServerboundPacket() {
        return new ServerboundTweakItemMap(this);
    }

    public static class Builder<V>
    extends TweakMap.Builder<Builder<V>, V, ItemMap<V>> {
        Builder(ItemMap<V> defaultList, TweakEnv env, Container container) {
            super(defaultList, env, container);
        }

        @Override
        Builder<V> self() {
            return this;
        }

        public TweakItemMap<V> build() {
            return new TweakItemMap(this);
        }
    }
}

