/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.factory;

import java.util.Locale;
import mod.adrenix.nostalgic.network.packet.tweak.ClientboundTweakEnum;
import mod.adrenix.nostalgic.network.packet.tweak.ServerboundTweakEnum;
import mod.adrenix.nostalgic.network.packet.tweak.TweakPacket;
import mod.adrenix.nostalgic.tweak.TweakEnv;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.tweak.factory.TweakValue;
import mod.adrenix.nostalgic.util.common.lang.DecodeLang;
import mod.adrenix.nostalgic.util.common.text.TextUtil;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class TweakEnum<T extends Enum<T>>
extends TweakValue<T> {
    public static <E extends Enum<E>> Builder<E> client(E defaultEnum, Container container) {
        return new Builder<E>(defaultEnum, TweakEnv.CLIENT, container);
    }

    public static <E extends Enum<E>> Builder<E> server(E defaultEnum, Container container) {
        return new Builder<E>(defaultEnum, TweakEnv.SERVER, container);
    }

    public static <E extends Enum<E>> Builder<E> dynamic(E defaultEnum, Container container) {
        return new Builder<E>(defaultEnum, TweakEnv.DYNAMIC, container);
    }

    TweakEnum(Builder<T> builder) {
        super(builder);
    }

    @Override
    public void setCacheValue(Enum<?> value) {
        this.setCacheValue(value);
    }

    private String getEnumKey(Enum<?> value) {
        return this.getLangKey() + ".enum." + value.name().toLowerCase(Locale.ROOT);
    }

    private String getStandardKey(Enum<?> value) {
        String className = TextUtil.lowercaseFirstLetter(value.getClass().getSimpleName());
        return "gui.nostalgic_tweaks.enum." + className + "." + value.name().toLowerCase(Locale.ROOT) + ".info";
    }

    @Nullable
    private String getCustomDescription(Enum<?> value) {
        String key = this.getEnumKey(value);
        String parsed = DecodeLang.findAndReplace((Component)Component.translatable((String)key)).getString();
        if (parsed.equals(key)) {
            return null;
        }
        return parsed;
    }

    @Nullable
    private String getStandardDescription(Enum<?> value) {
        String key = this.getStandardKey(value);
        String parsed = DecodeLang.findAndReplace((Component)Component.translatable((String)key)).getString();
        if (parsed.equals(key)) {
            return null;
        }
        return parsed;
    }

    public Component getEnumDescription(Enum<?> value) {
        String description = this.getCustomDescription(value);
        if (description != null) {
            return Component.literal((String)description);
        }
        String standard = this.getStandardDescription(value);
        if (standard != null) {
            return Component.literal((String)standard);
        }
        return Component.empty();
    }

    public boolean isEnumDescribed(Enum<?> value) {
        return this.getCustomDescription(value) != null || this.getStandardDescription(value) != null;
    }

    @Override
    @Nullable
    public TweakPacket getClientboundPacket() {
        return new ClientboundTweakEnum(this);
    }

    @Override
    @Nullable
    public TweakPacket getServerboundPacket() {
        return new ServerboundTweakEnum(this);
    }

    public static class Builder<V extends Enum<V>>
    extends TweakValue.Builder<V, Builder<V>> {
        Builder(V defaultValue, TweakEnv env, Container container) {
            super(defaultValue, env, container);
        }

        @Override
        Builder<V> self() {
            return this;
        }

        public TweakEnum<V> build() {
            return new TweakEnum(this);
        }
    }
}

