/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.factory;

import mod.adrenix.nostalgic.network.packet.tweak.TweakPacket;
import mod.adrenix.nostalgic.tweak.TweakEnv;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.tweak.factory.TweakValue;
import mod.adrenix.nostalgic.util.common.color.HexUtil;
import org.jetbrains.annotations.Nullable;

public class TweakColor
extends TweakValue<String> {
    private final Builder builder;

    public static Builder client(String defaultHex, Container container) {
        return new Builder(defaultHex, TweakEnv.CLIENT, container);
    }

    TweakColor(Builder builder) {
        super(builder);
        this.builder = builder;
    }

    public boolean isOpaque() {
        return !this.builder.hasTransparency;
    }

    @Override
    @Nullable
    public TweakPacket getClientboundPacket() {
        return null;
    }

    @Override
    @Nullable
    public TweakPacket getServerboundPacket() {
        return null;
    }

    public static class Builder
    extends TweakValue.Builder<String, Builder> {
        final boolean hasTransparency;

        Builder(String defaultValue, TweakEnv env, Container container) {
            super(defaultValue, env, container);
            if (!defaultValue.startsWith("#")) {
                throw new RuntimeException("Default color hex string did not start with #");
            }
            if (!HexUtil.isValid(defaultValue)) {
                throw new RuntimeException("Invalid default hex string: [A-F][0-9] or is not 6/8 chars in length");
            }
            this.hasTransparency = defaultValue.replace("#", "").length() > 6;
            this.load();
        }

        @Override
        Builder self() {
            return this;
        }

        public TweakColor build() {
            return new TweakColor(this);
        }
    }
}

