/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.factory;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.tweak.TweakAlert;
import mod.adrenix.nostalgic.tweak.TweakEnv;
import mod.adrenix.nostalgic.tweak.TweakIssue;
import mod.adrenix.nostalgic.tweak.TweakStatus;
import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;

public abstract class TweakBuilder<B extends TweakBuilder<B>> {
    final TweakEnv env;
    final Container container;
    final Set<TweakIssue> modIssues = new HashSet<TweakIssue>();
    final Set<ModTracker> conflictMods = new HashSet<ModTracker>();
    BooleanSupplier andIf = BooleanSupplier.ALWAYS;
    BooleanSupplier ignoreIf = BooleanSupplier.NEVER;
    TweakAlert alert = TweakAlert.NONE;
    TweakStatus status = TweakStatus.WAIT;
    boolean newForUpdate = false;
    boolean noNetworkCheck = false;
    boolean hasWarningTag = false;
    boolean doesChunkReload = false;
    boolean doesResourceReload = false;
    boolean noSSO = false;
    boolean top = false;

    TweakBuilder(TweakEnv env, Container container) {
        this.env = env;
        this.container = container;
        if (NostalgicTweaks.isServer()) {
            this.status = TweakStatus.FAIL;
        }
    }

    abstract B self();

    public B newForUpdate() {
        this.newForUpdate = true;
        return this.self();
    }

    public B top() {
        this.top = true;
        return this.self();
    }

    public B load() {
        this.status = TweakStatus.LOADED;
        return this.self();
    }

    public B ignore() {
        this.ignoreIf = BooleanSupplier.ALWAYS;
        return this.self();
    }

    public B ignoreIf(BooleanSupplier condition) {
        this.ignoreIf = condition;
        return this.self();
    }

    public B andIf(BooleanSupplier condition) {
        this.andIf = condition;
        return this.self();
    }

    public B reloadChunks() {
        this.doesChunkReload = true;
        return this.self();
    }

    public B reloadResources() {
        this.doesResourceReload = true;
        return this.self();
    }

    public B ignoreNetworkCheck() {
        this.noNetworkCheck = true;
        return this.self();
    }

    public B conflictMods(ModTracker ... mods) {
        this.conflictMods.addAll(Arrays.asList(mods));
        return this.self();
    }

    public B modIssues(TweakIssue ... issues) {
        this.modIssues.addAll(Arrays.asList(issues));
        return this.self();
    }

    public B warningTag() {
        this.hasWarningTag = true;
        return this.self();
    }

    public B noSSO() {
        this.noSSO = true;
        return this.self();
    }

    public B alert(TweakAlert alert) {
        this.alert = alert;
        return this.self();
    }
}

