/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.enums;

import com.google.common.base.Suppliers;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.tweak.enums.EnumTweak;
import mod.adrenix.nostalgic.util.client.animate.Animate;
import mod.adrenix.nostalgic.util.client.animate.Animation;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.lang.Translation;

public enum AnimationType implements EnumTweak
{
    LINEAR(Lang.Enum.ANIMATION_LINEAR, Animate::linear),
    EASE_IN_SINE(Lang.Enum.ANIMATION_EASE_IN_SINE, Animate::easeInSine),
    EASE_IN_CUBIC(Lang.Enum.ANIMATION_EASE_IN_CUBIC, Animate::easeInCubic),
    EASE_IN_CIRCULAR(Lang.Enum.ANIMATION_EASE_IN_CIRCULAR, Animate::easeInCircular),
    EASE_IN_EXPO(Lang.Enum.ANIMATION_EASE_IN_EXPO, Animate::easeInExpo),
    EASE_OUT_SINE(Lang.Enum.ANIMATION_EASE_OUT_SINE, Animate::easeOutSine),
    EASE_OUT_CUBIC(Lang.Enum.ANIMATION_EASE_OUT_CUBIC, Animate::easeOutCubic),
    EASE_OUT_CIRCULAR(Lang.Enum.ANIMATION_EASE_OUT_CIRCULAR, Animate::easeOutCircular),
    EASE_OUT_EXPO(Lang.Enum.ANIMATION_EASE_OUT_EXPO, Animate::easeOutExpo),
    EASE_IN_OUT_SINE(Lang.Enum.ANIMATION_EASE_IN_OUT_SINE, Animate::easeInOutSine),
    EASE_IN_OUT_CUBIC(Lang.Enum.ANIMATION_EASE_IN_OUT_CUBIC, Animate::easeInOutCubic),
    EASE_IN_OUT_CIRCULAR(Lang.Enum.ANIMATION_EASE_IN_OUT_CIRCULAR, Animate::easeInOutCircular),
    EASE_IN_OUT_EXPO(Lang.Enum.ANIMATION_EASE_IN_OUT_EXPO, Animate::easeInOutExpo);

    private final Translation title;
    private final Supplier<Function<Double, Double>> animation;

    private AnimationType(Translation title, Supplier<Animation> animator) {
        this.title = title;
        this.animation = Suppliers.memoize(() -> ((Animation)animator.get()).getAnimation());
    }

    public Function<Double, Double> getAnimation() {
        return this.animation.get();
    }

    @Override
    public Translation getTitle() {
        return this.title;
    }
}

