/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak.container;

import mod.adrenix.nostalgic.tweak.container.Container;
import mod.adrenix.nostalgic.tweak.container.ContainerType;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.asset.TextureLocation;
import mod.adrenix.nostalgic.util.common.color.Color;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ContainerBuilder {
    final String jsonId;
    final ContainerType type;
    boolean internal;
    boolean description;
    Container inheritance;
    Container parent;
    Color color;
    TextureIcon icon;

    ContainerBuilder(String jsonId, ContainerType type) {
        this.jsonId = jsonId;
        this.type = type;
    }

    public ContainerBuilder parent(Container container) {
        this.parent = container;
        return this;
    }

    public ContainerBuilder description() {
        this.description = true;
        return this;
    }

    public ContainerBuilder internal() {
        return this;
    }

    public ContainerBuilder inherit(Container category) {
        if (this.type != ContainerType.CATEGORY) {
            throw new AssertionError((Object)"Only 'category' containers can inherit other categories");
        }
        if (category.getType() != ContainerType.CATEGORY) {
            throw new AssertionError((Object)"Container inheritance must be from a 'category' container");
        }
        this.inheritance = category;
        return this;
    }

    public ContainerBuilder color(Color color) {
        this.color = color.lock();
        return this;
    }

    public ContainerBuilder color(int color) {
        this.color = new Color(color).lock();
        return this;
    }

    public ContainerBuilder icon(TextureIcon icon) {
        this.icon = icon;
        return this;
    }

    public ContainerBuilder icon(Item item) {
        this.icon = TextureIcon.fromItem(item);
        return this;
    }

    public ContainerBuilder icon(Block block) {
        this.icon = TextureIcon.fromBlock(block);
        return this;
    }

    public ContainerBuilder icon(TextureLocation location) {
        this.icon = TextureIcon.fromTexture(location);
        return this;
    }

    public Container build() {
        return new Container(this);
    }
}

