/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.config.ClientConfig;
import mod.adrenix.nostalgic.config.ServerConfig;
import mod.adrenix.nostalgic.config.factory.ConfigBuilder;
import mod.adrenix.nostalgic.config.factory.ConfigMeta;
import mod.adrenix.nostalgic.config.factory.LoaderException;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;
import mod.adrenix.nostalgic.tweak.listing.ListingMap;
import mod.adrenix.nostalgic.tweak.listing.ListingSet;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.CollectionUtil;
import mod.adrenix.nostalgic.util.common.log.LogColor;

public class TweakValidator {
    private static final String THROW_REASON = "Some tweaks failed validation. This is a developer error.";
    private final LinkedHashMap<String, String> exceptions = new LinkedHashMap();
    private final boolean internal;

    public static <T extends ConfigMeta> void check(Class<T> config) {
        try {
            new TweakValidator(false).scan(config);
        }
        catch (LoaderException exception) {
            ConfigBuilder.getHandler().reset();
        }
    }

    public static <T> void inspect(Tweak<T> tweak) {
        TweakValidator validator = new TweakValidator(false);
        if (tweak.validate(validator)) {
            return;
        }
        tweak.sync();
    }

    public TweakValidator(boolean internal) {
        this.internal = internal;
    }

    public <T extends ConfigMeta> void scan(Class<T> config) throws LoaderException {
        if (CollectionUtil.isNotEmpty(this.exceptions)) {
            throw new LoaderException(new Throwable(THROW_REASON));
        }
        if (this.internal) {
            NostalgicTweaks.LOGGER.debug("[Config Validator] Scanning default %s...", config.getSimpleName());
        } else {
            NostalgicTweaks.LOGGER.debug("[Config Validator] Scanning loaded %s...", config.getSimpleName());
        }
        if (config.equals(ClientConfig.class)) {
            TweakPool.values().forEach(this::validate);
        } else if (config.equals(ServerConfig.class)) {
            TweakPool.filter(Tweak::isMultiplayerLike).forEach(this::validate);
        }
        if (CollectionUtil.isNotEmpty(this.exceptions)) {
            for (Map.Entry<String, String> entry : this.exceptions.entrySet()) {
                String key = LogColor.apply(LogColor.GOLD, entry.getKey());
                String value = LogColor.apply(LogColor.LIGHT_PURPLE, entry.getValue());
                NostalgicTweaks.LOGGER.error("[Config Validator] %s did not pass validation: %s", key, value);
            }
            throw new LoaderException(new Throwable(THROW_REASON));
        }
    }

    public void exception(Tweak<?> tweak, String message) {
        this.exceptions.put(String.format("[Config Validator] %s [#%s]", tweak, this.exceptions.size()), message);
    }

    public void debug(String message, Object ... args) {
        NostalgicTweaks.LOGGER.debug("[Config Validator] " + message, args);
    }

    public void warn(String message, Object ... args) {
        NostalgicTweaks.LOGGER.warn("[Config Validator] " + message, args);
    }

    public boolean ok() {
        return this.exceptions.isEmpty();
    }

    public boolean erred() {
        return !this.ok();
    }

    private void validate(Tweak<?> tweak) {
        if (tweak.fromDisk() instanceof Collection && ClassUtil.isNotInstanceOf(tweak, ListingSet.class)) {
            this.exception(tweak, String.format("Collection tweaks must use %s.class", ListingSet.class.getSimpleName()));
        }
        if (tweak.fromDisk() instanceof Map && ClassUtil.isNotInstanceOf(tweak, ListingMap.class)) {
            this.exception(tweak, String.format("Map tweaks must use an instance of %s.class", ListingMap.class.getSimpleName()));
        }
        if (tweak.validate(this)) {
            return;
        }
        tweak.sync();
    }
}

