/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak;

import mod.adrenix.nostalgic.tweak.StatusContext;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import mod.adrenix.nostalgic.util.common.log.LogColor;
import net.minecraft.ChatFormatting;
import org.jetbrains.annotations.Nullable;

public enum TweakStatus implements StatusContext
{
    LOADED(ChatFormatting.GREEN, Lang.Text.LOADED, Lang.Status.LOADED, Icons.TRAFFIC_LIGHT_GREEN, null),
    WAIT(ChatFormatting.YELLOW, Lang.Text.WAIT, Lang.Status.WAIT, Icons.TRAFFIC_LIGHT_YELLOW, null),
    FAIL(ChatFormatting.RED, Lang.Text.FAIL, Lang.Status.FAIL, Icons.TRAFFIC_LIGHT_RED, Icons.TRAFFIC_LIGHT_OFF),
    WARN(ChatFormatting.GOLD, Lang.Text.WARN, Lang.Status.WARN, Icons.TRAFFIC_LIGHT_ORANGE, Icons.TRAFFIC_LIGHT_BLACK);

    private final ChatFormatting color;
    private final Translation title;
    private final Translation info;
    private final TextureIcon icon;
    @Nullable
    private final TextureIcon off;

    public static String toStringWithColor(TweakStatus status) {
        return switch (status.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> LogColor.apply(LogColor.GREEN, status.toString());
            case 1 -> LogColor.apply(LogColor.YELLOW, status.toString());
            case 3 -> LogColor.apply(LogColor.GOLD, status.toString());
            case 2 -> LogColor.apply(LogColor.RED, status.toString());
        };
    }

    private TweakStatus(ChatFormatting color, Translation title, @Nullable Translation info, TextureIcon icon, TextureIcon off) {
        this.color = color;
        this.title = title;
        this.info = info;
        this.icon = icon;
        this.off = off;
    }

    @Override
    public ChatFormatting getColor() {
        return this.color;
    }

    @Override
    public Translation getTitle() {
        return this.title;
    }

    @Override
    public Translation getInfo() {
        return this.info;
    }

    @Override
    public TextureIcon getIcon() {
        return this.icon;
    }

    @Override
    public TextureIcon getIcon(boolean isFlashing) {
        if (isFlashing && this.off != null) {
            return this.off;
        }
        return this.icon;
    }
}

