/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak;

import java.util.Locale;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.common.asset.Icons;
import mod.adrenix.nostalgic.util.common.asset.TextureIcon;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;
import mod.adrenix.nostalgic.util.common.lang.DecodeLang;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public enum TweakIssue {
    SODIUM(Lang.literal("Sodium"), Lang.Issue.SODIUM, Icons.SODIUM, Color.AZURE_WHITE, ModTracker.SODIUM::isInstalled),
    OPTIFINE(Lang.literal("Optifine"), Lang.Issue.OPTIFINE, Icons.OPTIFINE, Color.MUSTARD, ModTracker.OPTIFINE::isInstalled),
    POLYTONE(Lang.literal("Polytone"), Lang.Issue.POLYTONE, Icons.PAINTBRUSH, Color.LIGHT_BLUE, ModTracker.POLYTONE::isInstalled),
    IRIS(Lang.literal("Iris"), Lang.Issue.IRIS, Icons.COLOR_WHEEL, Color.IRIS_BLUE, ModTracker.IRIS::isInstalled);

    private final Translation title;
    private final Translation description;
    private final TextureIcon icon;
    private final Color color;
    private final BooleanSupplier active;

    private TweakIssue(Translation title, Translation description, TextureIcon icon, Color color, BooleanSupplier active) {
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.color = color;
        this.active = active;
    }

    public Translation getTitle() {
        return this.title;
    }

    public TextureIcon getIcon() {
        return this.icon;
    }

    public Color getColor() {
        return this.color;
    }

    public BooleanSupplier isActive() {
        return this.active;
    }

    public Component getDescription(Tweak<?> tweak) {
        String langKey = tweak.getLangKey() + ".issue." + this.toString().toLowerCase(Locale.ROOT);
        MutableComponent translation = DecodeLang.findAndReplace((Component)Component.translatable((String)langKey));
        if (translation.getString().equals(langKey) && this.description != null) {
            return this.description.get(new Object[0]);
        }
        return translation;
    }
}

