/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.tweak;

import java.util.function.Supplier;
import mod.adrenix.nostalgic.tweak.config.AnimationTweak;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.tweak.enums.FogColor;
import mod.adrenix.nostalgic.tweak.enums.InventoryShield;
import mod.adrenix.nostalgic.tweak.enums.SkyColor;
import mod.adrenix.nostalgic.util.common.lang.Lang;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.network.chat.Component;

public enum TweakAlert {
    NONE(TweakAlert::none, Lang.Alert.NONE),
    ROW_HIGHLIGHT_DISABLED(TweakAlert::isRowHighlightDisabled, Lang.Alert.ROW_HIGHLIGHT_DISABLED),
    WINDOW_TITLE_DISABLED(TweakAlert::isWindowTitleDisabled, Lang.Alert.WINDOW_TITLE_DISABLED),
    CUSTOM_GUI_DISABLED(TweakAlert::getCustomGuiDisabled, Lang.Alert.CUSTOM_GUI_GRADIENT),
    SHIELD_CONFLICT(TweakAlert::isShieldConflict, Lang.Alert.SHIELD),
    BRIGHTNESS_CONFLICT(TweakAlert::isBrightnessConflict, Lang.Alert.BRIGHTNESS),
    DYNAMIC_FOG(TweakAlert::isDynamicFogConflict, Lang.Alert.DYNAMIC_FOG),
    DYNAMIC_SKY(TweakAlert::isDynamicSkyConflict, Lang.Alert.DYNAMIC_SKY),
    UNIVERSAL_FOG(TweakAlert::isUniversalFogConflict, Lang.Alert.UNIVERSAL_FOG),
    UNIVERSAL_SKY(TweakAlert::isUniversalSkyConflict, Lang.Alert.UNIVERSAL_SKY),
    OVERWORLD_FOG_DENSITY(TweakAlert::isOverworldFogDensityConflict, Lang.Alert.OVERWORLD_FOG_DENSITY),
    OVERWORLD_FOG_COLOR(TweakAlert::isOverworldFogColorConflict, Lang.Alert.OVERWORLD_FOG_COLOR),
    NETHER_FOG_DENSITY(TweakAlert::isNetherFogDensityConflict, Lang.Alert.NETHER_FOG_DENSITY),
    NETHER_FOG_COLOR(TweakAlert::isNetherFogColorConflict, Lang.Alert.NETHER_FOG_COLOR),
    VOID_CONFLICT(TweakAlert::isVoidConflict, Lang.Alert.VOID),
    FOOD_HEALTH_CONFLICT(TweakAlert::isCustomFoodHealthConflict, Lang.Alert.FOOD_HEALTH),
    FOOD_STACKING_CONFLICT(TweakAlert::isCustomFoodStackingConflict, Lang.Alert.FOOD_STACKING),
    ARM_SWAY_CONFLICT(TweakAlert::isArmSwayConflict, Lang.Alert.ARM_SWAY),
    STAMINA_SPRINTING_CONFLICT(TweakAlert::isStaminaSprintingConflict, Lang.Alert.STAMINA_SPRINTING),
    CUSTOM_FALLING_LOGO_DISABLED(TweakAlert::isCustomFallingLogoDisabled, Lang.Alert.CUSTOM_FALLING_LOGO_DISABLED);

    private final Supplier<Boolean> condition;
    private final Translation langKey;

    private TweakAlert(Supplier<Boolean> condition, Translation langKey) {
        this.condition = condition;
        this.langKey = langKey;
    }

    public Supplier<Boolean> getCondition() {
        return this.condition;
    }

    public Component getMessage() {
        return this.langKey.get(new Object[0]);
    }

    private static boolean none() {
        return false;
    }

    private static boolean isCustomFallingLogoDisabled() {
        boolean isCustomFallingLogoOff = (Boolean)CandyTweak.USE_CUSTOM_FALLING_LOGO.fromCache() == false;
        boolean isOldAlphaLogoOff = (Boolean)CandyTweak.OLD_ALPHA_LOGO.fromCache() == false;
        return isCustomFallingLogoOff || isOldAlphaLogoOff;
    }

    private static boolean isRowHighlightDisabled() {
        return (Boolean)ModTweak.OVERRIDE_ROW_HIGHLIGHT.fromCache() == false;
    }

    private static boolean isWindowTitleDisabled() {
        return (Boolean)CandyTweak.ENABLE_WINDOW_TITLE.fromCache() == false;
    }

    private static boolean getCustomGuiDisabled() {
        return (Boolean)CandyTweak.CUSTOM_GUI_BACKGROUND.fromCache() == false;
    }

    private static boolean isShieldConflict() {
        boolean isModernShield = CandyTweak.INVENTORY_SHIELD.fromCache() == InventoryShield.MODERN;
        boolean isOldInventory = (Boolean)CandyTweak.OLD_INVENTORY.fromCache();
        return isModernShield && isOldInventory;
    }

    private static boolean isBrightnessConflict() {
        boolean isOldLightColor = (Boolean)CandyTweak.OLD_LIGHT_COLOR.fromCache();
        boolean isDisabledBrightness = (Boolean)CandyTweak.DISABLE_LIGHT_BRIGHTNESS.fromCache();
        boolean isDynamicBrightness = (Boolean)CandyTweak.DYNAMIC_LIGHT_BRIGHTNESS.fromCache();
        return !isOldLightColor && (isDisabledBrightness || isDynamicBrightness);
    }

    private static boolean isVoidConflict() {
        boolean isDarkVoidHeight = (Boolean)CandyTweak.OLD_DARK_VOID_HEIGHT.fromCache();
        boolean isBlueVoidOverride = (Boolean)CandyTweak.OLD_BLUE_VOID_OVERRIDE.fromCache();
        return isDarkVoidHeight && isBlueVoidOverride;
    }

    private static boolean isUniversalFogConflict() {
        FogColor fogColor = (FogColor)CandyTweak.UNIVERSAL_FOG_COLOR.fromCache();
        boolean isFogCustom = (Boolean)CandyTweak.USE_CUSTOM_OVERWORLD_FOG_COLOR.fromCache();
        boolean isFogDynamic = (Boolean)CandyTweak.OLD_DYNAMIC_FOG_COLOR.fromCache();
        return fogColor != FogColor.DISABLED && (isFogCustom || isFogDynamic);
    }

    private static boolean isUniversalSkyConflict() {
        SkyColor skyColor = (SkyColor)CandyTweak.UNIVERSAL_SKY_COLOR.fromCache();
        boolean isSkyCustom = (Boolean)CandyTweak.CUSTOM_OVERWORLD_SKY.fromCache();
        boolean isSkyDynamic = (Boolean)CandyTweak.OLD_DYNAMIC_SKY_COLOR.fromCache();
        return skyColor != SkyColor.DISABLED && (isSkyCustom || isSkyDynamic);
    }

    private static boolean isDynamicFogConflict() {
        boolean isFogCustom = (Boolean)CandyTweak.USE_CUSTOM_OVERWORLD_FOG_COLOR.fromCache();
        boolean isFogDynamic = (Boolean)CandyTweak.OLD_DYNAMIC_FOG_COLOR.fromCache();
        return isFogCustom && isFogDynamic;
    }

    private static boolean isDynamicSkyConflict() {
        boolean isSkyCustom = (Boolean)CandyTweak.CUSTOM_OVERWORLD_SKY.fromCache();
        boolean isSkyDynamic = (Boolean)CandyTweak.OLD_DYNAMIC_SKY_COLOR.fromCache();
        return isSkyCustom && isSkyDynamic;
    }

    private static boolean isOverworldFogColorConflict() {
        return (Boolean)CandyTweak.USE_CUSTOM_OVERWORLD_FOG_COLOR.fromCache() == false;
    }

    private static boolean isOverworldFogDensityConflict() {
        return (Boolean)CandyTweak.USE_CUSTOM_OVERWORLD_FOG_DENSITY.fromCache() == false;
    }

    private static boolean isNetherFogColorConflict() {
        return (Boolean)CandyTweak.USE_CUSTOM_NETHER_FOG_COLOR.fromCache() == false;
    }

    private static boolean isNetherFogDensityConflict() {
        return (Boolean)CandyTweak.USE_CUSTOM_NETHER_FOG_DENSITY.fromCache() == false;
    }

    private static boolean isCustomFoodHealthConflict() {
        return (Boolean)GameplayTweak.DISABLE_HUNGER.fromCache() == false;
    }

    private static boolean isCustomFoodStackingConflict() {
        return (Boolean)GameplayTweak.OLD_FOOD_STACKING.fromCache() == false;
    }

    private static boolean isArmSwayConflict() {
        return (Boolean)AnimationTweak.PREVENT_ARM_SWAY.fromCache();
    }

    private static boolean isStaminaSprintingConflict() {
        return (Boolean)GameplayTweak.DISABLE_SPRINT.fromCache();
    }
}

