/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.tweak;

import dev.architectury.networking.NetworkManager;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.toast.ToastNotification;
import mod.adrenix.nostalgic.config.cache.ConfigCache;
import mod.adrenix.nostalgic.network.packet.ModPacket;
import mod.adrenix.nostalgic.network.packet.tweak.ClientboundRejection;
import mod.adrenix.nostalgic.tweak.TweakValidator;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakMeta;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;
import mod.adrenix.nostalgic.util.client.network.NetUtil;
import mod.adrenix.nostalgic.util.client.timer.ClientTimer;
import mod.adrenix.nostalgic.util.common.log.LogColor;
import mod.adrenix.nostalgic.util.common.network.PacketUtil;
import mod.adrenix.nostalgic.util.server.ServerTimer;
import org.jetbrains.annotations.Nullable;

public interface TweakPacket
extends ModPacket {
    default public Optional<Tweak<?>> findOnClient(String poolId) {
        Optional<Tweak<?>> found = TweakPool.find(poolId);
        if (found.isEmpty()) {
            String message = "Server sent [tweak={jsonId:%s}] but it doesn't exist in the client config";
            NostalgicTweaks.LOGGER.debug(message, poolId);
        }
        return found;
    }

    default public void changeOnClient(NetworkManager.PacketContext context, String poolId, @Nullable Object receivedValue) {
        if (this.isServerHandling(context) || receivedValue == null) {
            return;
        }
        Optional<Tweak<?>> found = this.findOnClient(poolId);
        if (found.isEmpty()) {
            return;
        }
        Tweak<Object> tweak = TweakMeta.wildcard(found.get());
        String output = "Received tweak update from %s: [tweak={jsonId:%s, new:%s, old:%s}]";
        String jsonId = LogColor.apply(LogColor.LIGHT_PURPLE, poolId);
        String newValue = LogColor.apply(LogColor.BLUE, receivedValue.toString());
        String oldValue = LogColor.apply(LogColor.BLUE, tweak.fromServer().toString());
        if (NetUtil.isLocalHost()) {
            NostalgicTweaks.LOGGER.debug(output, "LAN player", jsonId, newValue, oldValue);
            boolean diskAppliedSafely = tweak.applySafely(receivedValue, tweak::setDisk);
            boolean localAppliedSafely = tweak.applySafely(receivedValue, tweak::setLocal);
            if (!diskAppliedSafely || !localAppliedSafely) {
                String message = "Unable to change [tweak={jsonId:%s}] from (%s) to (%s) - nothing was saved";
                NostalgicTweaks.LOGGER.warn(message, jsonId, oldValue, newValue);
                return;
            }
            ClientTimer.getInstance().runAfter(1L, TimeUnit.SECONDS, ConfigCache::save);
        } else {
            NostalgicTweaks.LOGGER.debug(output, "server", jsonId, newValue, oldValue);
        }
        boolean appliedSafely = tweak.applySafely(receivedValue, tweak::setReceived);
        if (!appliedSafely) {
            String message = "Received data that could not be applied [tweak={jsonId:%s}] from (%s) to (%s)";
            NostalgicTweaks.LOGGER.warn(message, jsonId, oldValue, newValue);
            return;
        }
        tweak.connect();
        if (NostalgicTweaks.isNetworkVerified()) {
            if (NetUtil.isLocalHost()) {
                ToastNotification.changeOnLan();
            } else {
                ToastNotification.changeOnClient();
            }
        }
    }

    default public Optional<Tweak<?>> findOnServer(NetworkManager.PacketContext context, String poolId) {
        Optional<Tweak<?>> found = TweakPool.find(poolId);
        if (found.isEmpty()) {
            String message = "Player (%s) requested [tweak={jsonId:%s}] but it doesn't exist in the server config";
            NostalgicTweaks.LOGGER.debug(message, this.getPlayerName(context), poolId);
        }
        return found;
    }

    default public void changeOnServer(NetworkManager.PacketContext context, String poolId, @Nullable Object receivedValue) {
        if (receivedValue == null) {
            return;
        }
        Optional<Tweak<?>> found = this.findOnServer(context, poolId);
        if (found.isEmpty()) {
            return;
        }
        Tweak<Object> tweak = TweakMeta.wildcard(found.get());
        if (this.isNotFromOperator(context)) {
            tweak.sendToPlayer(this.getServerPlayer(context));
            return;
        }
        boolean hasChanged = tweak.hasChanged(receivedValue);
        String update = "Received tweak update request from (%s): [tweak={jsonId:%s, new:%s, old:%s}]";
        String jsonId = LogColor.apply(LogColor.LIGHT_PURPLE, poolId);
        String newValue = LogColor.apply(LogColor.BLUE, receivedValue.toString());
        String oldValue = LogColor.apply(LogColor.BLUE, tweak.fromDisk().toString());
        this.log(update, this.getPlayerName(context), jsonId, newValue, oldValue);
        if (NostalgicTweaks.isClient() && NetUtil.isLocalHost() && ((Boolean)ModTweak.RESTRICTED_LAN.get()).booleanValue()) {
            String rejected = "LAN player (%s) tried changing tweak(s) but was rejected";
            NostalgicTweaks.LOGGER.debug(rejected, this.getPlayerName(context));
            PacketUtil.sendToPlayer(this.getServerPlayer(context), new ClientboundRejection());
            tweak.sendToPlayer(this.getServerPlayer(context));
            return;
        }
        boolean appliedSafely = tweak.applySafely(receivedValue, tweak::setDisk);
        if (!appliedSafely) {
            String message = "Unable to change [tweak={jsonId:%s}] from (%s) to (%s) - tweak change and config save aborted";
            NostalgicTweaks.LOGGER.warn(message, jsonId, oldValue, newValue);
            return;
        }
        TweakValidator.inspect(tweak);
        if (NostalgicTweaks.isServer() && hasChanged) {
            ServerTimer.getInstance().runAfter(1L, TimeUnit.SECONDS, ConfigCache::save);
        }
        tweak.sendToAll();
    }
}

