/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.tweak;

import dev.architectury.networking.NetworkManager;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.config.cache.CacheMode;
import mod.adrenix.nostalgic.network.packet.ModPacket;
import mod.adrenix.nostalgic.network.packet.tweak.TweakPacket;
import mod.adrenix.nostalgic.tweak.TweakStatus;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.util.common.log.LogColor;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record ClientboundStatusUpdate(String poolId, TweakStatus status) implements TweakPacket
{
    public static final CustomPacketPayload.Type<ClientboundStatusUpdate> TYPE = ModPacket.createType(ClientboundStatusUpdate.class);

    public ClientboundStatusUpdate(Tweak<?> tweak) {
        this(tweak.getJsonPathId(), tweak.getEnvStatus());
    }

    public ClientboundStatusUpdate(FriendlyByteBuf buffer) {
        this(buffer.readUtf(), (TweakStatus)buffer.readEnum(TweakStatus.class));
    }

    @Override
    public void encoder(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.poolId);
        buffer.writeEnum((Enum)this.status);
    }

    @Override
    public void receiver(NetworkManager.PacketContext context) {
        if (this.isServerHandling(context)) {
            return;
        }
        this.findOnClient(this.poolId).ifPresent(tweak -> tweak.setStatus(CacheMode.NETWORK, this.status));
        String output = "Received tweak update from server: [tweak={jsonId:%s, status:%s}]";
        String jsonId = LogColor.apply(LogColor.LIGHT_PURPLE, this.poolId);
        String status = TweakStatus.toStringWithColor(this.status);
        NostalgicTweaks.LOGGER.debug(output, jsonId, status);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

