/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.sync;

import dev.architectury.networking.NetworkManager;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.toast.ToastNotification;
import mod.adrenix.nostalgic.network.ModConnection;
import mod.adrenix.nostalgic.network.packet.ModPacket;
import mod.adrenix.nostalgic.network.packet.sync.ServerboundSyncAll;
import mod.adrenix.nostalgic.util.common.log.LogColor;
import mod.adrenix.nostalgic.util.common.network.PacketUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class ClientboundHandshake
implements ModPacket {
    public static final CustomPacketPayload.Type<ClientboundHandshake> TYPE = ModPacket.createType(ClientboundHandshake.class);
    protected final String json;

    public ClientboundHandshake(String loader, String version, String protocol) {
        this.json = new ModConnection(loader, version, protocol).serialize();
    }

    public ClientboundHandshake(FriendlyByteBuf buffer) {
        this.json = buffer.readUtf();
    }

    @Override
    public void encoder(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.json);
    }

    @Override
    public void receiver(NetworkManager.PacketContext context) {
        if (this.isServerHandling(context)) {
            return;
        }
        ModConnection.deserialize(this.json);
        ModConnection connection = NostalgicTweaks.getConnection().orElseGet(ModConnection::disconnected);
        String output = "Connected to server running Nostalgic Tweaks [modLoader=%s, version=%s, protocol=%s]";
        String loader = LogColor.apply(LogColor.AQUA, connection.getLoader());
        String version = LogColor.apply(LogColor.GREEN, connection.getVersion());
        String protocol = LogColor.apply(LogColor.LIGHT_PURPLE, connection.getProtocol());
        NostalgicTweaks.LOGGER.debug(output, loader, version, protocol);
        if (connection.getProtocol().equals("3.1")) {
            NostalgicTweaks.setNetworkVerification(true);
            ToastNotification.handshake();
            PacketUtil.sendToServer(new ServerboundSyncAll());
        } else {
            NostalgicTweaks.setNetworkVerification(false);
            NostalgicTweaks.LOGGER.warn("Connected to a server with Nostalgic Tweaks but received mismatched protocol");
            String info = "Protocol: [server=%s, client=%s]";
            String server = LogColor.apply(LogColor.RED, connection.getProtocol());
            String client = LogColor.apply(LogColor.GREEN, "3.1");
            NostalgicTweaks.LOGGER.warn(info, server, client);
            NostalgicTweaks.LOGGER.warn("Client should disconnect due to an incorrect mod network state");
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

