/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.backup;

import dev.architectury.networking.NetworkManager;
import java.nio.file.Path;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.config.ServerConfig;
import mod.adrenix.nostalgic.config.factory.ConfigBuilder;
import mod.adrenix.nostalgic.config.factory.ConfigHandler;
import mod.adrenix.nostalgic.network.packet.ModPacket;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakMeta;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record ServerboundReloadConfig() implements ModPacket
{
    public static final CustomPacketPayload.Type<ServerboundReloadConfig> TYPE = ModPacket.createType(ServerboundReloadConfig.class);

    public ServerboundReloadConfig(FriendlyByteBuf ignored) {
        this();
    }

    @Override
    public void encoder(FriendlyByteBuf buffer) {
    }

    @Override
    public void receiver(NetworkManager.PacketContext context) {
        if (this.isNotFromOperator(context)) {
            return;
        }
        Path reloadLocation = ConfigBuilder.getHandler().getPath();
        ConfigHandler<ServerConfig> hotSwap = ConfigBuilder.temp(ServerConfig.class, reloadLocation);
        if (hotSwap.load()) {
            ConfigHandler<ServerConfig> handler = ConfigBuilder.getHandler();
            handler.setLoaded(hotSwap.getLoaded());
            handler.save();
            this.log("[Config HotSwap] Reloaded the contents saved on disk", new Object[0]);
            TweakPool.filter(Tweak::isMultiplayerLike).forEach(TweakMeta::sendToAll);
        } else {
            NostalgicTweaks.LOGGER.error("[Config HotSwap] Could not reload contents saved on disk");
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

