/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.backup;

import dev.architectury.networking.NetworkManager;
import java.nio.file.Path;
import mod.adrenix.nostalgic.network.packet.ModPacket;
import mod.adrenix.nostalgic.network.packet.backup.BackupObject;
import mod.adrenix.nostalgic.network.packet.backup.ClientboundBackupDownload;
import mod.adrenix.nostalgic.network.packet.backup.DownloadType;
import mod.adrenix.nostalgic.util.common.network.PacketUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record ServerboundDownloadRequest(BackupObject backup, DownloadType downloadType) implements ModPacket
{
    public static final CustomPacketPayload.Type<ServerboundDownloadRequest> TYPE = ModPacket.createType(ServerboundDownloadRequest.class);

    public ServerboundDownloadRequest(FriendlyByteBuf buffer) {
        this(BackupObject.decode(buffer), (DownloadType)buffer.readEnum(DownloadType.class));
    }

    @Override
    public void encoder(FriendlyByteBuf buffer) {
        BackupObject.encode(buffer, this.backup);
        buffer.writeEnum((Enum)this.downloadType);
    }

    @Override
    public void receiver(NetworkManager.PacketContext context) {
        if (this.isNotFromOperator(context)) {
            return;
        }
        Path path = this.backup.getPath();
        String filename = path.getFileName().toString();
        this.log("Player (%s) requested and was sent (%s)", this.getPlayerName(context), filename);
        PacketUtil.sendToPlayer(this.getServerPlayer(context), new ClientboundBackupDownload(this.backup, this.downloadType));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

