/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.backup;

import com.google.common.collect.Sets;
import dev.architectury.networking.NetworkManager;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.network.packet.ModPacket;
import mod.adrenix.nostalgic.network.packet.backup.BackupObject;
import mod.adrenix.nostalgic.network.packet.backup.ExecuteOnClient;
import mod.adrenix.nostalgic.util.common.io.PathUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class ClientboundBackupObjects
implements ModPacket {
    public static final CustomPacketPayload.Type<ClientboundBackupObjects> TYPE = ModPacket.createType(ClientboundBackupObjects.class);
    final Set<BackupObject> backups;
    final boolean success;

    public ClientboundBackupObjects() {
        this.backups = new LinkedHashSet<BackupObject>();
        boolean hasError = false;
        try {
            List<Path> files = PathUtil.getNewestModified(PathUtil.getBackupPath(), PathUtil::isJsonFile);
            for (Path path : files) {
                this.backups.add(BackupObject.create(path));
            }
        }
        catch (IOException exception) {
            hasError = true;
            NostalgicTweaks.LOGGER.error("An error occurred when preparing the server's backup files\n%s", exception);
        }
        this.success = !hasError;
    }

    public ClientboundBackupObjects(FriendlyByteBuf buffer) {
        this.success = buffer.readBoolean();
        this.backups = (Set)buffer.readCollection(Sets::newLinkedHashSetWithExpectedSize, BackupObject::decode);
    }

    @Override
    public void encoder(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.success);
        buffer.writeCollection(this.backups, BackupObject::encode);
    }

    @Override
    public void receiver(NetworkManager.PacketContext context) {
        if (this.isServerHandling(context)) {
            return;
        }
        ExecuteOnClient.handleBackupObjects(this);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

