/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.backup;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import dev.architectury.networking.NetworkManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.network.packet.ModPacket;
import mod.adrenix.nostalgic.network.packet.backup.BackupObject;
import mod.adrenix.nostalgic.network.packet.backup.DownloadType;
import mod.adrenix.nostalgic.network.packet.backup.ExecuteOnClient;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class ClientboundBackupDownload
implements ModPacket {
    public static final CustomPacketPayload.Type<ClientboundBackupDownload> TYPE = ModPacket.createType(ClientboundBackupDownload.class);
    final DownloadType downloadType;
    final Set<String> chunks;
    final String filename;
    final boolean success;

    public ClientboundBackupDownload(BackupObject backup, DownloadType downloadType) {
        this.chunks = new LinkedHashSet<String>();
        this.filename = backup.getFilename();
        this.downloadType = downloadType;
        Path path = backup.getPath();
        boolean hasError = false;
        if (Files.exists(path, new LinkOption[0])) {
            try {
                String content = new String(Files.readAllBytes(path));
                Splitter splitter = Splitter.fixedLength((int)Short.MAX_VALUE);
                this.chunks.addAll(splitter.splitToList((CharSequence)content));
            }
            catch (IOException exception) {
                hasError = true;
                NostalgicTweaks.LOGGER.error("[I/O Error] Could not read backup file (%s)\n%s", this.filename, exception);
            }
        } else {
            hasError = true;
            NostalgicTweaks.LOGGER.error("[I/O Error] Could not found backup file (%s)", this.filename);
        }
        this.success = !hasError;
    }

    public ClientboundBackupDownload(FriendlyByteBuf buffer) {
        this.downloadType = (DownloadType)buffer.readEnum(DownloadType.class);
        this.filename = buffer.readUtf();
        this.success = buffer.readBoolean();
        this.chunks = (Set)buffer.readCollection(Sets::newLinkedHashSetWithExpectedSize, FriendlyByteBuf::readUtf);
    }

    @Override
    public void encoder(FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.downloadType);
        buffer.writeUtf(this.filename);
        buffer.writeBoolean(this.success);
        buffer.writeCollection(this.chunks, FriendlyByteBuf::writeUtf);
    }

    @Override
    public void receiver(NetworkManager.PacketContext context) {
        if (this.isServerHandling(context)) {
            return;
        }
        ExecuteOnClient.handleBackupDownload(this);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

