/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet.backup;

import java.nio.file.Path;
import mod.adrenix.nostalgic.util.common.io.PathUtil;
import net.minecraft.network.FriendlyByteBuf;

public class BackupObject {
    private final String filename;
    private final long timestamp;

    public static BackupObject create(Path path) {
        return new BackupObject(path.getFileName().toString(), PathUtil.getCreationTime(path));
    }

    private BackupObject(String filename, long timestamp) {
        this.filename = filename;
        this.timestamp = timestamp;
    }

    public static void encode(FriendlyByteBuf buffer, BackupObject backup) {
        buffer.writeUtf(backup.filename);
        buffer.writeLong(backup.timestamp);
    }

    public static BackupObject decode(FriendlyByteBuf buffer) {
        return new BackupObject(buffer.readUtf(), buffer.readLong());
    }

    public String getFilename() {
        return this.filename;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Path getPath() {
        return PathUtil.getBackupPath().resolve(this.filename);
    }
}

