/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.network.packet;

import dev.architectury.networking.NetworkManager;
import java.util.Locale;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.util.common.LocateResource;
import mod.adrenix.nostalgic.util.common.network.PacketUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;

public interface ModPacket
extends CustomPacketPayload {
    public static <T extends ModPacket> void register(NetworkManager.Side side, CustomPacketPayload.Type<T> type, StreamDecoder<FriendlyByteBuf, T> decoder) {
        if (NetworkManager.Side.C2S == side) {
            NetworkManager.registerReceiver((NetworkManager.Side)side, type, (StreamCodec)CustomPacketPayload.codec(ModPacket::encoder, decoder), ModPacket::receiver);
        } else if (NostalgicTweaks.isClient()) {
            NetworkManager.registerReceiver((NetworkManager.Side)side, type, (StreamCodec)CustomPacketPayload.codec(ModPacket::encoder, decoder), ModPacket::receiver);
        } else {
            NetworkManager.registerS2CPayloadType(type, (StreamCodec)CustomPacketPayload.codec(ModPacket::encoder, decoder));
        }
    }

    public static <T extends ModPacket> CustomPacketPayload.Type<T> createType(Class<? extends ModPacket> classType) {
        return new CustomPacketPayload.Type(LocateResource.mod(classType.getSimpleName().toLowerCase(Locale.ROOT)));
    }

    public void encoder(FriendlyByteBuf var1);

    public void receiver(NetworkManager.PacketContext var1);

    default public ServerPlayer getServerPlayer(NetworkManager.PacketContext context) {
        return (ServerPlayer)context.getPlayer();
    }

    default public String getPlayerName(NetworkManager.PacketContext context) {
        Component name = context.getPlayer().getDisplayName();
        if (name == null) {
            return "null";
        }
        return name.getString();
    }

    default public boolean isNotFromOperator(NetworkManager.PacketContext context) {
        if (this.isClientHandling(context)) {
            return true;
        }
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        String playerName = this.getPlayerName(context);
        if (PacketUtil.isPlayerOp(player)) {
            return false;
        }
        NostalgicTweaks.LOGGER.warn("Player (%s) tried changing server data without permission", playerName);
        return true;
    }

    default public void log(String message, Object ... args) {
        if (NostalgicTweaks.isServer() && ((Boolean)ModTweak.SERVER_LOGGING.get()).booleanValue()) {
            NostalgicTweaks.LOGGER.info(message, args);
        }
    }

    default public boolean isEnvHandling(NetworkManager.PacketContext context, Dist envType) {
        if (context.getEnv() == envType) {
            PacketUtil.warn(envType, this.getClass());
            return true;
        }
        return false;
    }

    default public boolean isClientHandling(NetworkManager.PacketContext context) {
        return this.isEnvHandling(context, Dist.CLIENT);
    }

    default public boolean isServerHandling(NetworkManager.PacketContext context) {
        return this.isEnvHandling(context, Dist.DEDICATED_SERVER);
    }
}

