/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.neoforge.setup;

import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.gui.screen.home.HomeScreen;
import mod.adrenix.nostalgic.neoforge.event.AppleSkinHandler;
import mod.adrenix.nostalgic.neoforge.event.EmbeddiumHandler;
import mod.adrenix.nostalgic.neoforge.gui.NostalgicGuiOverlay;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.gui.ModListScreen;
import net.neoforged.neoforge.common.NeoForge;

@EventBusSubscriber(modid="nostalgic_tweaks", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public abstract class ClientSetup {
    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, ClientSetup::getScreenFactory);
        GuiUtil.modListScreen = ModListScreen::new;
        if (ModTracker.APPLE_SKIN.isInstalled()) {
            NeoForge.EVENT_BUS.register(AppleSkinHandler.class);
            NostalgicTweaks.LOGGER.info("Registered AppleSkin Listener");
        }
        if (ModTracker.EMBEDDIUM.isInstalled()) {
            NeoForge.EVENT_BUS.register(EmbeddiumHandler.class);
            EmbeddiumHandler.init();
            NostalgicTweaks.LOGGER.info("Registered Embeddium Listener");
        }
    }

    private static IConfigScreenFactory getScreenFactory() {
        return (minecraft, screen) -> new HomeScreen(screen, false);
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiLayersEvent event) {
        for (NostalgicGuiOverlay overlay : NostalgicGuiOverlay.values()) {
            event.registerAbove(overlay.above(), overlay.id(), overlay.renderer());
        }
    }
}

