/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.neoforge.mixin.embeddium.candy.world_lighting;

import it.unimi.dsi.fastutil.longs.LongCollection;
import java.util.Iterator;
import mod.adrenix.nostalgic.helper.candy.light.LightingHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.common.data.Pair;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.SectionPos;
import org.embeddedt.embeddium.impl.render.EmbeddiumWorldRenderer;
import org.embeddedt.embeddium.impl.render.chunk.map.ChunkTracker;
import org.embeddedt.embeddium.impl.render.chunk.map.ChunkTrackerHolder;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Nullable
    private ClientLevel level;

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at={@At(value="HEAD")})
    private void nt_embeddium_world_lighting$onRenderLevel(CallbackInfo callback) {
        EmbeddiumWorldRenderer worldRenderer = EmbeddiumWorldRenderer.instanceNullable();
        if (this.level == null || worldRenderer == null) {
            return;
        }
        Iterator<Long> iterator = LightingHelper.SODIUM_REBUILD_QUEUE.iterator();
        while (iterator.hasNext()) {
            int z2;
            int y;
            SectionPos section = SectionPos.of((long)iterator.next());
            int x2 = section.x();
            if (!worldRenderer.isSectionReady(x2, y = section.y(), z2 = section.z())) continue;
            worldRenderer.scheduleRebuildForChunk(x2, y, z2, false);
            iterator.remove();
        }
        if (worldRenderer.isTerrainRenderComplete()) {
            LightingHelper.SODIUM_REBUILD_QUEUE.clear();
        }
        if (((Boolean)CandyTweak.ROUND_ROBIN_RELIGHT.get()).booleanValue() && LightingHelper.isRelightCheckEnqueued()) {
            ChunkTracker.forEachChunk((LongCollection)ChunkTrackerHolder.get((ClientLevel)this.level).getReadyChunks(), (x, z) -> {
                for (int y = this.level.getMinSection(); y < this.level.getMaxSection(); ++y) {
                    if (worldRenderer.isSectionReady(x, y, z)) {
                        worldRenderer.scheduleRebuildForChunk(x, y, z, false);
                    } else {
                        LightingHelper.SODIUM_REBUILD_QUEUE.add(SectionPos.asLong((int)x, (int)y, (int)z));
                    }
                    if (!ModTracker.FLYWHEEL.isInstalled()) continue;
                    LightingHelper.CHUNK_RELIGHT_QUEUE.add(SectionPos.asLong((int)x, (int)y, (int)z));
                }
            });
        }
        if (((Boolean)LightingHelper.RELIGHT_ALL_CHUNKS.get()).booleanValue() && this.level != null) {
            ChunkTrackerHolder.get((ClientLevel)this.level).getReadyChunks().forEach(packedPos -> {
                Pair<Long, Byte> packedRelight = new Pair<Long, Byte>(packedPos, (byte)1);
                LightingHelper.PACKED_RELIGHT_QUEUE.add(packedRelight);
            });
            LightingHelper.RELIGHT_ALL_CHUNKS.disable();
        }
    }

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at={@At(value="RETURN")})
    private void nt_embeddium_world_lighting$onFinishRenderLevel(CallbackInfo callback) {
        if (LightingHelper.isRelightCheckEnqueued()) {
            LightingHelper.setRelightingAsFinished();
        }
    }
}

