/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.neoforge.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import mod.adrenix.nostalgic.helper.candy.hud.HudHelper;
import mod.adrenix.nostalgic.helper.gameplay.stamina.StaminaRenderer;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.common.LocateResource;
import mod.adrenix.nostalgic.util.common.data.NullableResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

public enum NostalgicGuiOverlay {
    AIR("air", VanillaGuiLayers.PLAYER_HEALTH, (graphics, deltaTracker) -> {
        int maximum;
        Minecraft minecraft = Minecraft.getInstance();
        if (!((Boolean)CandyTweak.HIDE_HUNGER_BAR.get()).booleanValue() || minecraft.options.hideGui || minecraft.gameMode != null && !minecraft.gameMode.canHurtPlayer()) {
            return;
        }
        int supply = NullableResult.getOrElse(minecraft.player, 0, Entity::getAirSupply);
        if (supply >= (maximum = NullableResult.getOrElse(minecraft.player, 0, Entity::getMaxAirSupply).intValue())) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        HudHelper.renderAir(graphics, minecraft.gui.leftHeight, GuiUtil.getGuiWidth() / 2 - 100);
        minecraft.gui.leftHeight += 10;
        RenderSystem.disableBlend();
    }),
    ARMOR("armor", VanillaGuiLayers.EXPERIENCE_BAR, (graphics, deltaTracker) -> {
        Minecraft minecraft = Minecraft.getInstance();
        if (!((Boolean)CandyTweak.HIDE_HUNGER_BAR.get()).booleanValue() || minecraft.options.hideGui || minecraft.gameMode != null && !minecraft.gameMode.canHurtPlayer()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        HudHelper.renderArmor(graphics, minecraft.gui.rightHeight, GuiUtil.getGuiWidth() / 2 + 90);
        minecraft.gui.rightHeight += 10;
        RenderSystem.disableBlend();
    }),
    STAMINA("stamina", VanillaGuiLayers.EXPERIENCE_BAR, (graphics, deltaTracker) -> {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        StaminaRenderer.render(graphics, minecraft.gui.rightHeight);
        if (StaminaRenderer.isVisible()) {
            minecraft.gui.rightHeight += 10;
        }
        RenderSystem.disableBlend();
    });

    private final ResourceLocation id;
    private final ResourceLocation above;
    private final LayeredDraw.Layer renderer;

    private NostalgicGuiOverlay(String id, ResourceLocation above, LayeredDraw.Layer renderer) {
        this.id = LocateResource.mod(id);
        this.above = above;
        this.renderer = renderer;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public ResourceLocation above() {
        return this.above;
    }

    public LayeredDraw.Layer renderer() {
        return this.renderer;
    }
}

