/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.neoforge.event;

import mod.adrenix.nostalgic.helper.candy.level.fog.OverworldFogRenderer;
import mod.adrenix.nostalgic.helper.candy.level.fog.VoidFogRenderer;
import mod.adrenix.nostalgic.helper.candy.level.fog.WaterFogRenderer;
import mod.adrenix.nostalgic.helper.gameplay.InteractionHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.util.common.data.NullableResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(modid="nostalgic_tweaks", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public abstract class ClientEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void setupHighestGuiOverlayPre(RenderGuiLayerEvent.Pre event) {
        ResourceLocation overlay = event.getName();
        LocalPlayer player = Minecraft.getInstance().player;
        Gui gui = Minecraft.getInstance().gui;
        boolean isExperienceOff = (Boolean)CandyTweak.HIDE_EXPERIENCE_BAR.get();
        boolean isFoodOff = (Boolean)CandyTweak.HIDE_HUNGER_BAR.get();
        boolean isMounted = NullableResult.getOrElse(player, false, local -> local.jumpableVehicle() != null);
        if (overlay == VanillaGuiLayers.HOTBAR && isExperienceOff) {
            gui.leftHeight -= 7;
            gui.rightHeight -= 7;
            if (isMounted) {
                gui.leftHeight += 7;
                gui.rightHeight += 7;
            }
        }
        if (overlay == VanillaGuiLayers.EXPERIENCE_BAR && isExperienceOff) {
            event.setCanceled(true);
        }
        if (overlay == VanillaGuiLayers.EXPERIENCE_LEVEL && isExperienceOff) {
            event.setCanceled(true);
        }
        if (overlay == VanillaGuiLayers.FOOD_LEVEL && isFoodOff) {
            event.setCanceled(true);
        }
        if (overlay == VanillaGuiLayers.ARMOR_LEVEL && isFoodOff) {
            event.setCanceled(true);
        }
        if (overlay == VanillaGuiLayers.AIR_LEVEL && isFoodOff) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderFog(ViewportEvent.RenderFog event) {
        if (!((Boolean)ModTweak.ENABLED.get()).booleanValue()) {
            return;
        }
        if (OverworldFogRenderer.setupFog(event.getCamera(), event.getMode(), () -> ((ViewportEvent.RenderFog)event).getNearPlaneDistance(), () -> ((ViewportEvent.RenderFog)event).getFarPlaneDistance(), arg_0 -> ((ViewportEvent.RenderFog)event).setFogShape(arg_0), arg_0 -> ((ViewportEvent.RenderFog)event).setNearPlaneDistance(arg_0), arg_0 -> ((ViewportEvent.RenderFog)event).setFarPlaneDistance(arg_0))) {
            event.setCanceled(true);
        }
        if (WaterFogRenderer.setupFog(event.getCamera(), arg_0 -> ((ViewportEvent.RenderFog)event).setFogShape(arg_0), arg_0 -> ((ViewportEvent.RenderFog)event).setNearPlaneDistance(arg_0), arg_0 -> ((ViewportEvent.RenderFog)event).setFarPlaneDistance(arg_0))) {
            event.setCanceled(true);
        }
        if (VoidFogRenderer.setupFog(event.getCamera(), event.getMode(), () -> ((ViewportEvent.RenderFog)event).getNearPlaneDistance(), () -> ((ViewportEvent.RenderFog)event).getFarPlaneDistance(), arg_0 -> ((ViewportEvent.RenderFog)event).setNearPlaneDistance(arg_0), arg_0 -> ((ViewportEvent.RenderFog)event).setFarPlaneDistance(arg_0))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void computeFogColor(ViewportEvent.ComputeFogColor event) {
        if (!((Boolean)ModTweak.ENABLED.get()).booleanValue()) {
            return;
        }
        if (WaterFogRenderer.setupColor(event.getCamera(), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setRed(arg_0), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setGreen(arg_0), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setBlue(arg_0))) {
            return;
        }
        OverworldFogRenderer.setupColor(event.getCamera(), () -> ((ViewportEvent.ComputeFogColor)event).getRed(), () -> ((ViewportEvent.ComputeFogColor)event).getGreen(), () -> ((ViewportEvent.ComputeFogColor)event).getBlue(), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setRed(arg_0), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setGreen(arg_0), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setBlue(arg_0));
        VoidFogRenderer.setupColor(event.getCamera(), () -> ((ViewportEvent.ComputeFogColor)event).getRed(), () -> ((ViewportEvent.ComputeFogColor)event).getGreen(), () -> ((ViewportEvent.ComputeFogColor)event).getBlue(), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setRed(arg_0), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setGreen(arg_0), arg_0 -> ((ViewportEvent.ComputeFogColor)event).setBlue(arg_0));
    }

    @SubscribeEvent
    public static void onUseItem(InputEvent.InteractionKeyMappingTriggered event) {
        LocalPlayer player = Minecraft.getInstance().player;
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (player == null || hitResult == null || !event.isUseItem()) {
            return;
        }
        if (hitResult instanceof BlockHitResult) {
            BlockState blockState;
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            Item itemInHand = player.getItemInHand(event.getHand()).getItem();
            if (InteractionHelper.shouldNotUseItem(itemInHand, blockState = player.level().getBlockState(blockHitResult.getBlockPos()))) {
                event.setCanceled(true);
                event.setSwingHand(false);
            }
        }
    }
}

