/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.swing;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import mod.adrenix.nostalgic.helper.animation.PlayerArmHelper;
import mod.adrenix.nostalgic.helper.swing.SwingHelper;
import mod.adrenix.nostalgic.helper.swing.SwingType;
import mod.adrenix.nostalgic.tweak.config.AnimationTweak;
import mod.adrenix.nostalgic.tweak.config.SwingTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    private LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyReturnValue(method={"getCurrentSwingDuration()I"}, at={@At(value="RETURN")})
    private int nt_swing$modifyCurrentSwingDuration(int currentSwingDuration) {
        Player entity;
        LocalPlayer player = Minecraft.getInstance().player;
        if (((Boolean)SwingTweak.OVERRIDE_SPEEDS.get()).booleanValue() || player == null) {
            return currentSwingDuration;
        }
        if (!(this.getType() != EntityType.PLAYER || (entity = (Player)this.getType().tryCast((Entity)this)) != null && entity.isLocalPlayer())) {
            return currentSwingDuration;
        }
        int speed = SwingHelper.getSwingSpeed((AbstractClientPlayer)player);
        if (((Boolean)AnimationTweak.OLD_CLASSIC_ATTACK_SWING.get()).booleanValue() && PlayerArmHelper.SWING_TYPE.get() == SwingType.ATTACK) {
            return SwingHelper.isSpeedGlobal() ? speed : 7;
        }
        if (((Boolean)AnimationTweak.OLD_CLASSIC_USE_SWING.get()).booleanValue() && PlayerArmHelper.SWING_TYPE.get() == SwingType.USE) {
            return SwingHelper.isSpeedGlobal() ? speed : 3;
        }
        if (SwingHelper.isSpeedGlobal()) {
            return speed;
        }
        if (SwingHelper.isHasteOverride() && player.hasEffect(MobEffects.DIG_SPEED)) {
            return SwingHelper.getHasteSpeed();
        }
        if (SwingHelper.isFatigueOverride() && player.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            return SwingHelper.getFatigueSpeed();
        }
        if (MobEffectUtil.hasDigSpeed((LivingEntity)player)) {
            return speed - (1 + MobEffectUtil.getDigSpeedAmplification((LivingEntity)player));
        }
        boolean isSlowdown = player.hasEffect(MobEffects.DIG_SLOWDOWN);
        MobEffectInstance slowdown = player.getEffect(MobEffects.DIG_SLOWDOWN);
        return isSlowdown ? speed + (1 + (slowdown != null ? slowdown.getAmplifier() : 0)) * 2 : speed;
    }
}

