/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.gameplay.mechanics_minecart;

import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.util.client.network.NetUtil;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Unique
    private float nt$riderXRotDelta;
    @Unique
    private float nt$riderYRotDelta;

    @Shadow
    @Nullable
    public abstract Entity getVehicle();

    @Shadow
    public abstract void setXRot(float var1);

    @Shadow
    public abstract void setYRot(float var1);

    @Shadow
    public abstract float getXRot();

    @Shadow
    public abstract float getYRot();

    @Inject(method={"rideTick()V"}, at={@At(shift=At.Shift.AFTER, value="INVOKE", target="Lnet/minecraft/world/entity/Entity;positionRider(Lnet/minecraft/world/entity/Entity;)V")})
    private void nt_mechanics_minecart$onRideTick(CallbackInfo callback) {
        if (NostalgicTweaks.isServer() || !((Boolean)GameplayTweak.CART_RIDER_TURNING.get()).booleanValue()) {
            return;
        }
        if (NetUtil.isMultiplayer() && !NostalgicTweaks.isNetworkVerified() && ((Boolean)GameplayTweak.CART_SAFE_RIDER_TURNING.get()).booleanValue()) {
            return;
        }
        Entity vehicle = this.getVehicle();
        Entity self = (Entity)this;
        if (vehicle == null || vehicle.getControllingPassenger() == self) {
            return;
        }
        if (vehicle instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)vehicle;
            this.nt$riderYRotDelta = this.nt$riderYRotDelta + living.getVisualRotationYInDegrees() - living.yBodyRotO;
        } else {
            this.nt$riderYRotDelta = this.nt$riderYRotDelta + vehicle.getYRot() - vehicle.yRotO;
        }
        this.nt$riderXRotDelta = this.nt$riderXRotDelta + vehicle.getXRot() - vehicle.xRotO;
        this.nt$riderXRotDelta = MathUtil.normalizeInRange(this.nt$riderXRotDelta, -180.0f, 180.0f);
        this.nt$riderYRotDelta = MathUtil.normalizeInRange(this.nt$riderYRotDelta, -180.0f, 180.0f);
        float xRotFinal = Mth.clamp((float)(this.nt$riderXRotDelta * 0.5f), (float)-10.0f, (float)10.0f);
        float yRotFinal = Mth.clamp((float)(this.nt$riderYRotDelta * 0.5f), (float)-10.0f, (float)10.0f);
        this.nt$riderXRotDelta -= xRotFinal;
        this.nt$riderYRotDelta -= yRotFinal;
        this.setXRot(this.getXRot() + xRotFinal);
        this.setYRot(this.getYRot() + yRotFinal);
    }

    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="HEAD")})
    private void nt_mechanics_minecart$onStartRiding(CallbackInfoReturnable<Boolean> callback) {
        this.nt$riderXRotDelta = 0.0f;
        this.nt$riderYRotDelta = 0.0f;
    }
}

