/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.gameplay.mechanics_boat;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalDoubleRef;
import mod.adrenix.nostalgic.helper.gameplay.BoatHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Boat.class})
public abstract class BoatMixin
extends VehicleEntity {
    @Shadow
    private Boat.Status status;
    @Shadow
    private float invFriction;

    private BoatMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract Boat.Type getVariant();

    @WrapWithCondition(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/Boat;ejectPassengers()V")})
    private boolean nt_mechanics_boat$shouldEjectPassengersWhenOutOfControl(Boat boat) {
        return (Boolean)GameplayTweak.OLD_BOAT_WATER_LIFT.get() == false;
    }

    @Inject(method={"floatBoat()V"}, at={@At(shift=At.Shift.BEFORE, ordinal=1, value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/Boat;getDeltaMovement()Lnet/minecraft/world/phys/Vec3;")})
    private void nt_mechanics_boat$setWaterLiftFriction(CallbackInfo callback) {
        if (((Boolean)GameplayTweak.OLD_BOAT_WATER_LIFT.get()).booleanValue() && BoatHelper.isWaterLift(this.status)) {
            this.invFriction = 0.9f;
        }
    }

    @ModifyArg(index=1, method={"floatBoat()V"}, at=@At(ordinal=0, value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/Boat;setDeltaMovement(DDD)V"))
    private double nt_mechanics_boat$modifyGravity(double y, @Share(value="deltaY") LocalDoubleRef deltaY) {
        deltaY.set((Boolean)GameplayTweak.OLD_BOAT_WATER_LIFT.get() != false ? BoatHelper.getGravityAmount((Boat)this, this.status) : y);
        return deltaY.get();
    }

    @Inject(method={"floatBoat()V"}, at={@At(value="RETURN")})
    private void nt_mechanics_boat$setWaterLiftVerticalMovement(CallbackInfo callback, @Share(value="deltaY") LocalDoubleRef deltaY) {
        if (((Boolean)GameplayTweak.OLD_BOAT_WATER_LIFT.get()).booleanValue() && BoatHelper.isWaterLift(this.status)) {
            double dx = this.getDeltaMovement().x;
            double dy = BoatHelper.getLiftAmount(deltaY.get());
            double dz = this.getDeltaMovement().z;
            this.setDeltaMovement(dx, dy, dz);
        }
    }

    @Inject(method={"floatBoat()V"}, at={@At(value="RETURN")})
    private void nt_mechanics_boat$addSpeedParticles(CallbackInfo callback) {
        if (this.level().isClientSide() && ((Boolean)CandyTweak.OLD_BOAT_MOVEMENT_PARTICLES.get()).booleanValue()) {
            BoatHelper.applyParticles((Boat)this);
        }
    }

    @ModifyReturnValue(method={"getDropItem()Lnet/minecraft/world/item/Item;"}, at={@At(value="RETURN")})
    private Item nt_mechanics_boat$modifyDroppedItems(Item dropItem) {
        if (!((Boolean)GameplayTweak.OLD_BOAT_DROPS.get()).booleanValue()) {
            return dropItem;
        }
        this.spawnAtLocation(new ItemStack((ItemLike)this.getVariant().getPlanks()));
        this.spawnAtLocation(new ItemStack((ItemLike)this.getVariant().getPlanks()));
        this.spawnAtLocation(new ItemStack((ItemLike)Items.STICK));
        return ItemStack.EMPTY.getItem();
    }
}

