/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.gameplay.food_health;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import mod.adrenix.nostalgic.helper.gameplay.FoodHelper;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.tweak.listing.ItemMap;
import mod.adrenix.nostalgic.util.common.data.NullableResult;
import mod.adrenix.nostalgic.util.common.world.ItemUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    private PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")})
    private void nt_food_health$onPlayerEat(Level level, ItemStack itemStack, FoodProperties foodProperties, CallbackInfoReturnable<ItemStack> callback) {
        if (((Boolean)GameplayTweak.DISABLE_HUNGER.get()).booleanValue() && ItemUtil.isEdible(itemStack)) {
            FoodProperties food = (FoodProperties)itemStack.get(DataComponents.FOOD);
            int healAmount = NullableResult.getOrElse(food, 0, FoodProperties::nutrition);
            if (((ItemMap)GameplayTweak.CUSTOM_FOOD_HEALTH.get()).containsItem(itemStack)) {
                healAmount = (Integer)((ItemMap)GameplayTweak.CUSTOM_FOOD_HEALTH.get()).valueFrom(itemStack);
            }
            this.heal(healAmount);
        }
    }

    @ModifyReturnValue(method={"canEat(Z)Z"}, at={@At(value="RETURN")})
    private boolean nt_food_health$canPlayerEat(boolean playerCanEat, boolean canAlwaysEat) {
        if (((Boolean)GameplayTweak.DISABLE_HUNGER.get()).booleanValue() && !canAlwaysEat) {
            return Mth.ceil((float)this.getHealth()) < Mth.ceil((float)this.getMaxHealth());
        }
        return playerCanEat;
    }

    @WrapWithCondition(method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V")})
    private boolean nt_food_health$shouldPlayBurpSound(Level level, Player player, double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch) {
        return !FoodHelper.isInstantaneousEdible(this.getUseItem());
    }
}

