/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.gameplay.food_health;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import mod.adrenix.nostalgic.helper.gameplay.FoodHelper;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    protected ItemStack useItem;

    @Shadow
    public abstract ItemStack getItemInHand(InteractionHand var1);

    @WrapWithCondition(method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V")})
    private boolean nt_food_health$shouldPlayConsumedFoodSound(Level level, Player player, double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch, Level arg1, ItemStack foodItem) {
        return !FoodHelper.isInstantaneousEdible(foodItem);
    }

    @WrapWithCondition(method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;addEatEffect(Lnet/minecraft/world/food/FoodProperties;)V")})
    private boolean nt_food_health$shouldAddFoodEffects(LivingEntity instance, FoodProperties foodProperties, Level level, ItemStack food) {
        return !FoodHelper.isInstantaneousEdible(food) || (Boolean)GameplayTweak.PREVENT_INSTANT_EAT_EFFECTS.get() == false;
    }

    @ModifyReturnValue(method={"canBeAffected(Lnet/minecraft/world/effect/MobEffectInstance;)Z"}, at={@At(value="RETURN")})
    private boolean nt_food_health$shouldAddHungerEffect(boolean canBeAffected, MobEffectInstance effectInstance) {
        if (((Boolean)GameplayTweak.PREVENT_HUNGER_EFFECT.get()).booleanValue() && effectInstance.getEffect() == MobEffects.HUNGER) {
            return false;
        }
        return canBeAffected;
    }

    @ModifyExpressionValue(method={"startUsingItem(Lnet/minecraft/world/InteractionHand;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getUseDuration(Lnet/minecraft/world/entity/LivingEntity;)I")})
    private int nt_food_health$modifyUseDurationOnStartUsingItem(int useDuration, InteractionHand hand) {
        if (FoodHelper.isInstantaneousEdible(this.getItemInHand(hand))) {
            return 1;
        }
        return useDuration;
    }

    @WrapWithCondition(method={"updateUsingItem(Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;triggerItemUseEffects(Lnet/minecraft/world/item/ItemStack;I)V")})
    private boolean nt_food_health$shouldTriggerItemUseEffectsOnUpdate(LivingEntity entity, ItemStack usingItem, int amount) {
        return !FoodHelper.isInstantaneousEdible(usingItem);
    }

    @WrapWithCondition(method={"completeUsingItem()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;triggerItemUseEffects(Lnet/minecraft/world/item/ItemStack;I)V")})
    private boolean nt_food_health$shouldTriggerItemUseEffectsOnComplete(LivingEntity entity, ItemStack ItemStack2, int amount) {
        return !FoodHelper.isInstantaneousEdible(this.useItem);
    }
}

