/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.gameplay.combat_player;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import mod.adrenix.nostalgic.helper.gameplay.combat.SwordBlockingHelper;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    @Nullable
    public MultiPlayerGameMode gameMode;
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Final
    public Options options;
    @Shadow
    protected int missTime;

    @Inject(method={"startAttack()Z"}, at={@At(value="HEAD")})
    private void nt_combat_player$onStartAttack(CallbackInfoReturnable<Boolean> callback) {
        if (((Boolean)GameplayTweak.DISABLE_MISS_TIMER.get()).booleanValue()) {
            this.missTime = 0;
        }
    }

    @Inject(method={"continueAttack(Z)V"}, at={@At(value="HEAD")})
    private void nt_combat_player$onContinueAttack(boolean leftClick, CallbackInfo callback) {
        if (((Boolean)GameplayTweak.DISABLE_MISS_TIMER.get()).booleanValue()) {
            this.missTime = 0;
        }
    }

    @WrapWithCondition(method={"startUseItem()V"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isItemEnabled(Lnet/minecraft/world/flag/FeatureFlagSet;)Z"))}, at={@At(ordinal=2, value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;swing(Lnet/minecraft/world/InteractionHand;)V")})
    private boolean nt_combat_player$shouldSwingOnSwordBlock(LocalPlayer player, InteractionHand hand) {
        return !SwordBlockingHelper.isBlocking((Player)player);
    }

    @WrapWithCondition(method={"startUseItem()V"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isItemEnabled(Lnet/minecraft/world/flag/FeatureFlagSet;)Z"))}, at={@At(ordinal=1, value="INVOKE", target="Lnet/minecraft/client/renderer/ItemInHandRenderer;itemUsed(Lnet/minecraft/world/InteractionHand;)V")})
    private boolean nt_combat_player$shouldSetItemAsUsed(ItemInHandRenderer itemInHandRenderer, InteractionHand hand) {
        if (this.player == null) {
            return true;
        }
        return !SwordBlockingHelper.isBlocking((Player)this.player);
    }

    @ModifyExpressionValue(method={"handleKeybinds()V"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;openChatScreen(Ljava/lang/String;)V"))}, at={@At(ordinal=0, value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isUsingItem()Z")})
    private boolean nt_combat_player$shouldAttackWhenSwordBlocking(boolean isUsingItem) {
        if (this.player == null || this.gameMode == null) {
            return isUsingItem;
        }
        if (((Boolean)GameplayTweak.ATTACK_WHILE_SWORD_BLOCKING.get()).booleanValue() && SwordBlockingHelper.isBlocking((Player)this.player)) {
            if (!this.options.keyUse.isDown()) {
                this.gameMode.releaseUsingItem((Player)this.player);
            }
            return false;
        }
        return isUsingItem;
    }

    @ModifyExpressionValue(method={"continueAttack(Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isUsingItem()Z")})
    private boolean nt_combat_player$shouldContinueAttackWhenSwordBlocking(boolean isUsingItem) {
        if (this.player == null) {
            return isUsingItem;
        }
        if (((Boolean)GameplayTweak.ATTACK_WHILE_SWORD_BLOCKING.get()).booleanValue() && SwordBlockingHelper.isBlocking((Player)this.player)) {
            return false;
        }
        return isUsingItem;
    }
}

