/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.gameplay.combat_player;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.util.Optional;
import mod.adrenix.nostalgic.helper.gameplay.combat.SwordBlockingHelper;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @ModifyVariable(argsOnly=true, method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="HEAD"))
    private float nt_combat_player$onPlayerHurt(float hurtAmount) {
        Optional<Player> optionalPlayer = ClassUtil.cast(this, Player.class);
        if (optionalPlayer.isEmpty() || !optionalPlayer.get().isUsingItem()) {
            return hurtAmount;
        }
        Player player = optionalPlayer.get();
        if (SwordBlockingHelper.isBlocking(player)) {
            if (hurtAmount > 1.0f) {
                player.getUseItem().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                if (player.getUseItem().isEmpty()) {
                    player.stopUsingItem();
                }
            }
            return hurtAmount * (1.0f - (float)((Integer)GameplayTweak.SWORD_BLOCK_DAMAGE_REDUCTION.get()).intValue() / 100.0f);
        }
        return hurtAmount;
    }

    @ModifyExpressionValue(method={"startUsingItem(Lnet/minecraft/world/InteractionHand;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getUseDuration(Lnet/minecraft/world/entity/LivingEntity;)I")})
    private int nt_combat_player$modifyGetUseDuration(int useDuration) {
        return ClassUtil.cast(this, Player.class).filter(SwordBlockingHelper::canBlock).map(player -> 72000).orElse(useDuration);
    }
}

