/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.gameplay.animal_spawn;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import mod.adrenix.nostalgic.helper.gameplay.AnimalSpawnHelper;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.data.FlagHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Animal.class})
public abstract class AnimalMixin
extends Mob {
    private AnimalMixin(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyExpressionValue(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/Animal;isFood(Lnet/minecraft/world/item/ItemStack;)Z")})
    private boolean nt_animal_spawn$modifyIsFoodOnMobInteract(boolean isFood) {
        return (Boolean)GameplayTweak.DISABLE_ANIMAL_BREEDING.get() == false && isFood;
    }

    @ModifyReturnValue(method={"removeWhenFarAway(D)Z"}, at={@At(value="RETURN")})
    private boolean nt_animal_spawn$modifyRemoveWhenFarAway(boolean removeWhenFarAway) {
        Saddleable saddleable;
        AnimalMixin animalMixin;
        if (!((Boolean)GameplayTweak.OLD_ANIMAL_SPAWNING.get()).booleanValue() || !AnimalSpawnHelper.isInList(this.getType())) {
            return removeWhenFarAway;
        }
        if (((Boolean)GameplayTweak.KEEP_BABY_ANIMAL_WHILE_OLD_SPAWN.get()).booleanValue() && this.isPersistenceRequired()) {
            return removeWhenFarAway;
        }
        FlagHolder leashed = FlagHolder.off();
        FlagHolder saddled = FlagHolder.off();
        FlagHolder tamed = FlagHolder.off();
        if (this.mayBeLeashed()) {
            leashed.enable();
        }
        if ((animalMixin = this) instanceof Saddleable && (saddleable = (Saddleable)animalMixin).isSaddled()) {
            saddled.enable();
        }
        ClassUtil.cast((Object)this, TamableAnimal.class).ifPresent(tamable -> {
            if (tamable.isTame()) {
                tamed.enable();
            }
        });
        if (!(((Boolean)leashed.get()).booleanValue() || ((Boolean)saddled.get()).booleanValue() || ((Boolean)tamed.get()).booleanValue())) {
            return true;
        }
        return removeWhenFarAway;
    }

    @Inject(method={"finalizeSpawnChildFromBreeding(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/animal/Animal;Lnet/minecraft/world/entity/AgeableMob;)V"}, at={@At(value="HEAD")})
    private void nt_animal_spawn$onFinalizeSpawnChildFromBreeding(ServerLevel level, Animal animal, AgeableMob baby, CallbackInfo callback) {
        if (AnimalSpawnHelper.isPersistent(baby)) {
            baby.setPersistenceRequired();
        }
    }
}

