/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.gameplay.animal_sheep;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import mod.adrenix.nostalgic.helper.gameplay.SheepHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={EatBlockGoal.class})
public abstract class EatBlockGoalMixin {
    @Shadow
    @Final
    private Mob mob;
    @Shadow
    private int eatAnimationTick;

    @ModifyReturnValue(method={"canUse()Z"}, at={@At(value="RETURN")})
    private boolean nt_animal_sheep$modifyCanEatGrass(boolean canEatGrass) {
        if (SheepHelper.isEatGrassDisabled(this.mob)) {
            return false;
        }
        return canEatGrass;
    }

    @WrapWithCondition(method={"start()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;broadcastEntityEvent(Lnet/minecraft/world/entity/Entity;B)V")})
    private boolean nt_animal_sheep$canBroadcastEatEvent(Level level, Entity entity, byte state) {
        return !SheepHelper.isRandomWoolRegen(this.mob);
    }

    @WrapWithCondition(method={"start()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/navigation/PathNavigation;stop()V")})
    private boolean nt_animal_sheep$canEatStopNavigation(PathNavigation navigation) {
        return !SheepHelper.isRandomWoolRegen(this.mob);
    }

    @ModifyReturnValue(method={"getEatAnimationTick()I"}, at={@At(value="RETURN")})
    private int nt_animal_sheep$modifyGetEatAnimationTick(int eatAnimationTick) {
        if (SheepHelper.isRandomWoolRegen(this.mob)) {
            return 0;
        }
        return eatAnimationTick;
    }

    @ModifyExpressionValue(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/EatBlockGoal;adjustedTickDelay(I)I")})
    private int nt_animal_sheep$modifyActionOnFinishEatGoal(int adjustedTickDelay) {
        if (SheepHelper.isRandomWoolRegen(this.mob) && this.eatAnimationTick == adjustedTickDelay) {
            this.mob.ate();
            return 0;
        }
        return adjustedTickDelay;
    }
}

