/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.candy.world_sky;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import mod.adrenix.nostalgic.client.AfterConfigSave;
import mod.adrenix.nostalgic.helper.candy.level.SkyHelper;
import mod.adrenix.nostalgic.helper.candy.level.fog.VoidFogRenderer;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.tweak.enums.Generic;
import mod.adrenix.nostalgic.tweak.enums.WorldFog;
import mod.adrenix.nostalgic.util.client.GameUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Nullable
    private ClientLevel level;
    @Shadow
    @Final
    private Minecraft minecraft;

    @Shadow
    protected abstract void createStars();

    @Shadow
    private static MeshData buildSkyDisc(Tesselator tesselator, float y) {
        return null;
    }

    @Inject(method={"<init>(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderDispatcher;Lnet/minecraft/client/renderer/RenderBuffers;)V"}, at={@At(value="RETURN")})
    private void nt_world_sky$onCreateLevelRenderer(CallbackInfo callback) {
        SkyHelper.createBlueVoid(LevelRendererMixin::buildSkyDisc);
        if (SkyHelper.STARS_RUNNABLE_SAVED.ifDisabledThenEnable()) {
            AfterConfigSave.addInstruction(this::createStars);
        }
        if (SkyHelper.BLUE_RUNNABLE_SAVED.ifDisabledThenEnable()) {
            AfterConfigSave.addInstruction(() -> SkyHelper.createBlueVoid(LevelRendererMixin::buildSkyDisc));
        }
    }

    @Inject(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, at={@At(shift=At.Shift.AFTER, value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Matrix4f;)V")})
    private void nt_world_sky$onRenderSky(Matrix4f frustumMatrix, Matrix4f projectionMatrix, float partialTick, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo callback, @Local PoseStack poseStack) {
        if (!((Boolean)ModTweak.ENABLED.get()).booleanValue()) {
            return;
        }
        SkyHelper.MODEL_VIEW_MATRIX.set(new Matrix4f((Matrix4fc)poseStack.last().pose()));
        SkyHelper.PROJECTION_MATRIX.set(new Matrix4f((Matrix4fc)projectionMatrix));
    }

    @Inject(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, at={@At(ordinal=1, shift=At.Shift.AFTER, value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V")})
    private void nt_world_sky$onDrawSkyBuffer(CallbackInfo callback) {
        if (CandyTweak.OLD_BLUE_VOID.get() == Generic.MODERN) {
            return;
        }
        SkyHelper.setBlueColor();
        ShaderInstance shader = RenderSystem.getShader();
        if (shader != null) {
            SkyHelper.BLUE_VOID_BUFFER.ifPresent(buffer -> {
                buffer.bind();
                buffer.drawWithShader(SkyHelper.MODEL_VIEW_MATRIX.get(), SkyHelper.PROJECTION_MATRIX.get(), shader);
                VertexBuffer.unbind();
            });
        }
    }

    @WrapWithCondition(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"))}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexBuffer;drawWithShader(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lnet/minecraft/client/renderer/ShaderInstance;)V")})
    private boolean nt_world_sky$onRenderVoid(VertexBuffer buffer, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, ShaderInstance shader) {
        boolean isBlueRendered;
        if (!((Boolean)ModTweak.ENABLED.get()).booleanValue()) {
            return true;
        }
        Generic voidState = (Generic)CandyTweak.OLD_BLUE_VOID.get();
        boolean isBlueOverride = (Boolean)CandyTweak.OLD_BLUE_VOID_OVERRIDE.get();
        boolean bl = isBlueRendered = Generic.ALPHA == voidState || Generic.BETA == voidState;
        if (!isBlueRendered || !isBlueOverride) {
            float[] DARK_RGB = RenderSystem.getShaderColor();
            float[] VOID_RGB = VoidFogRenderer.getVoidRGB();
            VoidFogRenderer.setVoidRGB(DARK_RGB[0], DARK_RGB[1], DARK_RGB[2]);
            if (VoidFogRenderer.isRendering()) {
                RenderSystem.setShaderColor((float)VOID_RGB[0], (float)VOID_RGB[1], (float)VOID_RGB[2], (float)DARK_RGB[3]);
            }
            return true;
        }
        return false;
    }

    @Inject(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/FogRenderer;setupNoFog()V")})
    private void nt_world_sky$onSetupStarColor(Matrix4f frustumMatrix, Matrix4f projectionMatrix, float partialTick, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo callback) {
        Generic starsState = (Generic)CandyTweak.OLD_STARS.get();
        if (!((Boolean)ModTweak.ENABLED.get()).booleanValue() || this.level == null) {
            return;
        }
        float rain = 1.0f - ((Boolean)CandyTweak.PREVENT_WEATHER_INFLUENCE.get() != false ? 0.0f : this.level.getRainLevel(partialTick));
        float transparency = this.level.getStarBrightness(partialTick) * rain;
        float color = Generic.BETA == starsState ? transparency : transparency / 0.5f;
        VoidFogRenderer.setStarsTransparency(transparency);
        if (VoidFogRenderer.isRendering()) {
            transparency = VoidFogRenderer.getStarsTransparency();
        }
        if (Generic.MODERN != starsState) {
            RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)transparency);
        }
        if (CandyTweak.OLD_WORLD_FOG.get() == WorldFog.ALPHA_R164 && GameUtil.getRenderDistance() <= 4) {
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        }
    }

    @ModifyArg(index=1, method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V"))
    private float nt_world_sky$setTranslationForDarkSkyBuffer(float y) {
        if (!((Boolean)CandyTweak.OLD_DARK_VOID_HEIGHT.get()).booleanValue()) {
            return y;
        }
        return (float)((double)y - Math.max(this.minecraft.gameRenderer.getMainCamera().getPosition().y - 65.0, 0.0));
    }

    @ModifyExpressionValue(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/DimensionSpecialEffects;getSunriseColor(FF)[F")})
    private float[] nt_world_sky$setSunriseColor(float[] color) {
        return (float[])((Boolean)CandyTweak.RENDER_SUNRISE_SUNSET_COLOR.get() != false ? color : null);
    }

    @ModifyArg(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, at=@At(ordinal=2, value="INVOKE", target="Lcom/mojang/math/Axis;rotationDegrees(F)Lorg/joml/Quaternionf;"))
    private float nt_world_sky$setSkyDiscColorRotation(float rotation) {
        return (Boolean)CandyTweak.OLD_SUNRISE_AT_NORTH.get() != false ? 0.0f : rotation;
    }

    @ModifyArg(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, at=@At(ordinal=3, value="INVOKE", target="Lcom/mojang/math/Axis;rotationDegrees(F)Lorg/joml/Quaternionf;"))
    private float nt_world_sky$setCelestialRotation(float rotation) {
        return (Boolean)CandyTweak.OLD_SUNRISE_AT_NORTH.get() != false ? 0.0f : rotation;
    }

    @ModifyExpressionValue(method={"drawStars(Lcom/mojang/blaze3d/vertex/Tesselator;)Lcom/mojang/blaze3d/vertex/MeshData;"}, at={@At(value="CONSTANT", args={"floatValue=0.15F"})})
    private float nt_world_sky$setStarWidth(float width) {
        return switch ((Generic)CandyTweak.OLD_STARS.get()) {
            case Generic.ALPHA, Generic.BETA -> 0.25f;
            default -> width;
        };
    }

    @ModifyExpressionValue(method={"drawStars(Lcom/mojang/blaze3d/vertex/Tesselator;)Lcom/mojang/blaze3d/vertex/MeshData;"}, at={@At(value="CONSTANT", args={"floatValue=0.1F"})})
    private float nt_world_sky$setStarHeight(float height) {
        return switch ((Generic)CandyTweak.OLD_STARS.get()) {
            case Generic.ALPHA, Generic.BETA -> 0.25f;
            default -> height;
        };
    }
}

