/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.candy.world_lighting;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.blaze3d.platform.NativeImage;
import mod.adrenix.nostalgic.helper.candy.light.LightTextureHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.dimension.DimensionType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightTexture.class})
public abstract class LightTextureMixin {
    @Shadow
    private float blockLightRedFlicker;
    @Shadow
    @Final
    private NativeImage lightPixels;
    @Shadow
    @Final
    private Minecraft minecraft;

    @Shadow
    protected abstract float getDarknessGamma(float var1);

    @Shadow
    protected abstract float calculateDarknessScale(LivingEntity var1, float var2, float var3);

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void nt_world_lighting$setRedLightFlicker(CallbackInfo callback) {
        if (((Boolean)CandyTweak.DISABLE_LIGHT_FLICKER.get()).booleanValue()) {
            this.blockLightRedFlicker = 0.0f;
        }
    }

    @ModifyExpressionValue(method={"updateLightTexture(F)V"}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/client/renderer/LightTexture;blockLightRedFlicker:F"), to=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LightTexture;getBrightness(Lnet/minecraft/world/level/dimension/DimensionType;I)F"))}, at={@At(value="CONSTANT", args={"intValue=16"})})
    private int nt_world_lighting$setLightmapIndexes(int index) {
        if (((Boolean)CandyTweak.OLD_CLASSIC_ENGINE.get()).booleanValue() || ((Boolean)CandyTweak.OLD_LIGHT_COLOR.get()).booleanValue()) {
            return 0;
        }
        return index;
    }

    @Inject(method={"updateLightTexture(F)V"}, at={@At(shift=At.Shift.BEFORE, value="INVOKE", target="Lnet/minecraft/client/renderer/texture/DynamicTexture;upload()V")})
    private void nt_world_lighting$onBeforeLightmapUpload(float partialTick, CallbackInfo callback) {
        if (((Boolean)CandyTweak.OLD_CLASSIC_ENGINE.get()).booleanValue()) {
            LightTextureHelper.setClassicTexture(this.lightPixels);
            return;
        }
        if (((Boolean)CandyTweak.OLD_LIGHT_COLOR.get()).booleanValue()) {
            float darknessScale = ((Double)this.minecraft.options.darknessEffectScale().get()).floatValue();
            float darknessGamma = this.getDarknessGamma(partialTick) * darknessScale;
            float darknessEffect = this.calculateDarknessScale((LivingEntity)this.minecraft.player, darknessGamma, partialTick) * darknessScale;
            LightTextureHelper.setGrayscaleTexture(this.lightPixels, darknessEffect, partialTick);
        }
    }

    @ModifyReturnValue(method={"getBrightness(Lnet/minecraft/world/level/dimension/DimensionType;I)F"}, at={@At(value="RETURN")})
    private static float nt_world_lighting$modifyGetBrightness(float brightness, DimensionType dimensionType, int lightLevel) {
        if (((Boolean)CandyTweak.OLD_LIGHT_COLOR.get()).booleanValue()) {
            return Mth.lerp((float)dimensionType.ambientLight(), (float)((float)Math.pow(0.8, 15.0 - (double)lightLevel)), (float)1.0f);
        }
        return brightness;
    }
}

