/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.candy.world_lighting;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import mod.adrenix.nostalgic.helper.candy.light.NostalgicDataLayer;
import mod.adrenix.nostalgic.util.client.GameUtil;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.SkyLightEngine;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LightEngine.class})
public abstract class LightEngineMixin {
    @Shadow
    @Final
    protected LightChunkGetter chunkSource;

    @ModifyReturnValue(method={"getLightValue(Lnet/minecraft/core/BlockPos;)I"}, at={@At(value="RETURN")})
    private int nt_world_lighting$getLightValue(int lightValue, BlockPos blockPos) {
        LightLayer layer;
        if (GameUtil.isOnIntegratedSeverThread() || ClassUtil.isNotInstanceOf(this.chunkSource, ClientChunkCache.class)) {
            return lightValue;
        }
        LightLayer lightLayer = layer = ClassUtil.isInstanceOf(this, SkyLightEngine.class) ? LightLayer.SKY : LightLayer.BLOCK;
        if (this.chunkSource.getLevel() instanceof ClientLevel) {
            return NostalgicDataLayer.getLightValue(layer, blockPos, lightValue);
        }
        return lightValue;
    }
}

