/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.candy.world_lighting;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import mod.adrenix.nostalgic.helper.candy.light.LightingHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.config.ModTweak;
import mod.adrenix.nostalgic.util.ModTracker;
import mod.adrenix.nostalgic.util.common.data.Pair;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.PrioritizeChunkUpdates;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Nullable
    private ClientLevel level;
    @Shadow
    @Nullable
    private ViewArea viewArea;

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at={@At(value="HEAD")})
    private void nt_world_lighting$onRenderLevel(DeltaTracker deltaTracker, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f frustumMatrix, Matrix4f projectionMatrix, CallbackInfo callback) {
        if (((Boolean)ModTweak.ENABLED.get()).booleanValue()) {
            LightingHelper.checkRelightQueues();
        }
    }

    @Inject(method={"allChanged()V"}, at={@At(value="HEAD")})
    private void nt_world_lighting$onAllChanged(CallbackInfo callback) {
        if (!((Boolean)LightingHelper.RELIGHT_ALL_CHUNKS.get()).booleanValue() || ModTracker.SODIUM.isInstalled() || this.level == null || this.viewArea == null) {
            return;
        }
        for (SectionRenderDispatcher.RenderSection renderSection : this.viewArea.sections) {
            if (renderSection == null || renderSection.getCompiled().hasNoRenderableLayers()) continue;
            long packedPos = SectionPos.of((BlockPos)renderSection.getOrigin()).chunk().toLong();
            LightingHelper.PACKED_RELIGHT_QUEUE.add(new Pair<Long, Byte>(packedPos, (byte)1));
        }
        LightingHelper.RELIGHT_ALL_CHUNKS.disable();
    }

    @Inject(method={"compileSections(Lnet/minecraft/client/Camera;)V"}, at={@At(value="HEAD")})
    private void nt_world_lighting$onCompileSections(Camera camera, CallbackInfo callback) {
        boolean isRelightNeeded;
        boolean bl = isRelightNeeded = (Boolean)CandyTweak.ROUND_ROBIN_RELIGHT.get() != false && LightingHelper.isRelightCheckEnqueued();
        if (!isRelightNeeded || this.viewArea == null || this.level == null || ModTracker.SODIUM.isInstalled()) {
            return;
        }
        LightingHelper.CHUNK_RELIGHT_QUEUE.clear();
        for (SectionRenderDispatcher.RenderSection renderSection : this.viewArea.sections) {
            if (renderSection == null || renderSection.getCompiled().hasNoRenderableLayers()) continue;
            SectionPos sectionPos = SectionPos.of((BlockPos)renderSection.getOrigin());
            if (!this.level.getLightEngine().lightOnInSection(sectionPos)) continue;
            LightingHelper.CHUNK_RELIGHT_QUEUE.add(sectionPos.asLong());
        }
    }

    @ModifyExpressionValue(method={"compileSections(Lnet/minecraft/client/Camera;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/OptionInstance;get()Ljava/lang/Object;")})
    private <T> T nt_world_lighting$onGetCompilePriority(T chunkPriority) {
        if (ModTracker.SODIUM.isInstalled()) {
            return chunkPriority;
        }
        return (T)((Boolean)CandyTweak.ROUND_ROBIN_RELIGHT.get() != false && LightingHelper.isRelightCheckEnqueued() ? PrioritizeChunkUpdates.NONE : chunkPriority);
    }

    @Inject(method={"compileSections(Lnet/minecraft/client/Camera;)V"}, at={@At(value="RETURN")})
    private void nt_world_lighting$onFinishCompileSections(Camera camera, CallbackInfo callback) {
        if (LightingHelper.isRelightCheckEnqueued() && !ModTracker.SODIUM.isInstalled()) {
            LightingHelper.setRelightingAsFinished();
        }
    }
}

