/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.candy.world_lighting;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.blaze3d.systems.RenderSystem;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.helper.candy.block.ChestHelper;
import mod.adrenix.nostalgic.helper.candy.light.LightingHelper;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.common.world.BlockUtil;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BlockStateBaseMixin {
    @Shadow
    public abstract int getLightEmission();

    @Shadow
    public abstract Block getBlock();

    @Shadow
    protected abstract BlockState asState();

    @ModifyReturnValue(method={"emissiveRendering(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="RETURN")})
    private boolean nt_world_lighting$modifyEmissiveRendering(boolean isEmissive) {
        if (NostalgicTweaks.isMixinEarly()) {
            return isEmissive;
        }
        if (((Boolean)CandyTweak.OLD_CLASSIC_ENGINE.get()).booleanValue() && this.getLightEmission() > 0) {
            return true;
        }
        if (((Boolean)CandyTweak.OLD_LIGHT_COLOR.get()).booleanValue() && this.getLightEmission() >= 14) {
            return true;
        }
        return isEmissive;
    }

    @ModifyReturnValue(method={"getLightBlock(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)I"}, at={@At(value="RETURN")})
    private int nt_world_lighting$modifyLightBlock(int lightBlock) {
        if (NostalgicTweaks.isMixinEarly() || !RenderSystem.isOnRenderThread()) {
            return lightBlock;
        }
        return LightingHelper.LIGHT_BLOCK_CACHE.computeIfAbsent(this.getBlock(), block -> {
            if (((Boolean)CandyTweak.OLD_WATER_LIGHTING.get()).booleanValue() && BlockUtil.isWaterLike(this.asState())) {
                return 3;
            }
            if (((Boolean)CandyTweak.CHEST_LIGHT_BLOCK.get()).booleanValue() && ChestHelper.isOld(this.getBlock()) && !ChestHelper.isTranslucent(this.getBlock())) {
                return 15;
            }
            return lightBlock;
        });
    }
}

