/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.candy.missing_texture;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.blaze3d.platform.NativeImage;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.client.AfterConfigSave;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.enums.MissingTexture;
import mod.adrenix.nostalgic.util.common.asset.TextureLocation;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MissingTextureAtlasSprite.class})
public abstract class MissingTextureAtlasSpriteMixin {
    @Shadow
    @Nullable
    private static DynamicTexture missingTexture;

    @ModifyReturnValue(method={"generateMissingImage(II)Lcom/mojang/blaze3d/platform/NativeImage;"}, at={@At(value="RETURN")})
    private static NativeImage nt_missing_texture$modifyMissingImage(NativeImage nativeImage) {
        if (CandyTweak.OLD_MISSING_TEXTURE.get() == MissingTexture.MODERN) {
            return nativeImage;
        }
        Optional<Object> image = Optional.empty();
        try {
            image = MissingTextureAtlasSpriteMixin.nt_missing_texture$get();
        }
        catch (Exception exception) {
            NostalgicTweaks.LOGGER.error("Could not generate missing texture\n%s", exception);
        }
        return image.orElse(nativeImage);
    }

    @ModifyExpressionValue(method={"create()Lnet/minecraft/client/renderer/texture/SpriteContents;"}, at={@At(value="CONSTANT", args={"intValue=16"})})
    private static int nt_missing_texture$modifyImageDimension(int vanilla) {
        return switch ((MissingTexture)CandyTweak.OLD_MISSING_TEXTURE.get()) {
            case MissingTexture.BETA, MissingTexture.R15 -> 64;
            default -> vanilla;
        };
    }

    @Inject(method={"<clinit>()V"}, at={@At(value="TAIL")})
    private static void nt_missing_texture$addOnSave(CallbackInfo callback) {
        AfterConfigSave.addInstruction(MissingTextureAtlasSpriteMixin::nt_missing_texture$clearMissingTexture);
    }

    @Unique
    private static void nt_missing_texture$clearMissingTexture() {
        if (AfterConfigSave.areResourcesGoingToReload()) {
            missingTexture = null;
        }
    }

    @Unique
    private static Optional<NativeImage> nt_missing_texture$get() throws IOException {
        String path = switch ((MissingTexture)CandyTweak.OLD_MISSING_TEXTURE.get()) {
            case MissingTexture.BETA -> TextureLocation.MISSING_BETA;
            case MissingTexture.R15 -> TextureLocation.MISSING_1_5;
            case MissingTexture.R16_R112 -> TextureLocation.MISSING_1_6_1_12;
            default -> "";
        };
        Optional resource = Platform.getMod((String)"nostalgic_tweaks").findResource(new String[]{path});
        if (resource.isPresent()) {
            return Optional.of(NativeImage.read((InputStream)Files.newInputStream((Path)resource.get(), new OpenOption[0])));
        }
        return Optional.empty();
    }
}

