/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.mixin.tweak.candy.chest_block;

import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.util.common.CalendarUtil;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ModelBakery.class})
public abstract class ModelBakeryMixin {
    @ModifyVariable(method={"loadBlockModel(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/block/model/BlockModel;"}, argsOnly=true, ordinal=0, at=@At(value="HEAD"))
    private ResourceLocation nt_chest_block$modifyBlockModelLocation(ResourceLocation resourceLocation) {
        String minecraft = "minecraft";
        String namespace = resourceLocation.getNamespace();
        String path = resourceLocation.getPath();
        String modId = "nostalgic_tweaks";
        boolean isOldChest = (Boolean)CandyTweak.OLD_CHEST.get();
        boolean isOldEnderChest = (Boolean)CandyTweak.OLD_ENDER_CHEST.get();
        boolean isOldTrappedChest = (Boolean)CandyTweak.OLD_TRAPPED_CHEST.get();
        if (!namespace.equals(minecraft)) {
            return resourceLocation;
        }
        switch (path) {
            case "block/chest": 
            case "item/chest": {
                String string;
                if (isOldChest) {
                    string = modId;
                    break;
                }
                string = minecraft;
                break;
            }
            case "block/ender_chest": 
            case "item/ender_chest": {
                String string;
                if (isOldEnderChest) {
                    string = modId;
                    break;
                }
                string = minecraft;
                break;
            }
            case "block/trapped_chest": 
            case "item/trapped_chest": {
                String string;
                if (isOldTrappedChest) {
                    string = modId;
                    break;
                }
                string = minecraft;
                break;
            }
            default: {
                String string = namespace = namespace;
            }
        }
        if (isOldChest && !isOldEnderChest && path.equals("item/ender_chest")) {
            return ResourceLocation.fromNamespaceAndPath((String)"nostalgic_tweaks", (String)"item/vanilla_ender_chest");
        }
        if (isOldChest && !isOldTrappedChest && path.equals("item/trapped_chest")) {
            return ResourceLocation.fromNamespaceAndPath((String)"nostalgic_tweaks", (String)"item/vanilla_trapped_chest");
        }
        if (isOldChest && CalendarUtil.isChristmasTime()) {
            if (path.equals("block/chest")) {
                return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)"block/christmas_chest");
            }
            if (path.equals("item/chest")) {
                return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)"item/christmas_chest");
            }
        }
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }
}

